<?php

namespace App\Services;

use Carbon\Carbon;
use App\Models\Pop;
use App\Models\Client;
use App\Models\Balance;
use App\Models\Packages;
use App\Models\SubPackage;
use Illuminate\Http\Request;
use App\Services\ExpireCheck;
use App\Models\CustomerAccount;
use App\Services\ClientServices;
use App\Services\PriceCalculate;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Models\ReselleBalanceLogReport;
use App\Models\SubResellerBalanceLogReport;
use App\Http\Controllers\BillGenerateController;
use App\Models\BillGenerate;

class SecondMonthlyBillGenerateForDayToDay
{
    public function generate($id,$type,$amount,$description,$parmanent_discount,$package_name,$package_rate,$expire_date)
    {
        $dueAmount = DB::table('customer_accounts')->where('client_id', $id)->first();



        $client_id_time = $id . 'Seconde' . '_' . now()->format('Y-m-d H:i');

        $bill                   = new BillGenerate();
        $bill->description      = $description;
        $bill->bill_amount      = $amount - $parmanent_discount;
        $bill->client_id        = $id;
        $bill->billing_type     = $type;
        $bill->due_date         = date('Y-m-d', strtotime($expire_date));
        $bill->due_amount       = $dueAmount->dueAmount;
        $bill->paid_amount       = $amount - $parmanent_discount;
        $bill->parmanent_discount = $parmanent_discount;
        $bill->package_name     = $package_name;
        $bill->package_rate     = $package_rate;
        $bill->client_id_time   = $client_id_time;
        $bill->created_at       = $request_month ?? now();
        $bill->updated_at       = $request_month ?? now();
        $bill->save();

        return $bill;
    }

}
