@extends('Customer.customer-layout')


@section('body')
    @include('Customer.left-menu')


    <main id="main" class="main">
        <div class="pagetitle">
            <h1>Dashboard</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('customerDashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Dashboard</li>
                </ol>
            </nav>
        </div><!-- End Page Title -->

        <section class="section dashboard">
            <div class="row">

                <!-- Left side columns -->
                <div class="col-lg-12">
                    <div class="row">

                        <!-- Sales Card -->
                        <div class="col-12 col-md-6 col-lg-3 mb-3">
                            <div class="card info-card sales-card">
                                <div class="card-body">
                                    <h5 class="card-title">Balance <span>| Inquiry</span></h5>
                                    <div class="d-flex align-items-center">
                                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-bank2"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6>
                                                @if (isset($details['account']->dueAmount) && $details['account']->dueAmount < 1)
                                                    {{ abs($details['account']->dueAmount) }}
                                                @else
                                                    0
                                                @endif
                                            </h6>
                                            <span class="text-success small pt-1 fw-bold">Due</span>
                                            <span class="text-muted small pt-2 ps-1">
                                                @if (isset($details['account']->dueAmount) && $details['account']->dueAmount > 0)
                                                    <span class="text-red-600 font-bold">
                                                        {{ abs($details['account']->dueAmount) }}
                                                    </span>
                                                @else
                                                    0
                                                @endif
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- End Sales Card -->

                        <!-- Revenue Card -->
                        <div class="col-12 col-md-6 col-lg-3 mb-3">
                            <div class="card info-card revenue-card">
                                <div class="card-body">
                                    <h5 class="card-title">Packages |
                                        @if(checkSettings('package-name-show-in-customer-dashboard') == 'enable')
                                        <span> {{ $details['package']->package_name }}</span>
                                        @endif
                                    </h5>

                                    <div class="d-flex align-items-center">
                                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-box-seam"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6>{{ $details['package']->package_rate }}TK</h6>
                                            <span class="text-success small pt-1 fw-bold">Expire:</span> <span class="text-muted small pt-2 ps-1">{{ date('d-M-Y', strtotime($details['userinfo']->expire_date)) }}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- End Revenue Card -->

                        <!-- Customers Card -->
                        <div class="col-12 col-md-6 col-lg-3 mb-3">
                            <div onclick="location.href='{{ route('customer-payment') }}'" class="card info-card customers-card">
                                <div class="card-body">
                                    <h5 class="card-title">Recharge <span>| Account</span></h5>
                                    <div class="d-flex align-items-center">
                                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-currency-exchange"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6><a href="{{ route('customer-payment') }}">Pay Now</a></h6>
                                            <span><a href="{{ route('customer-payment') }}" class="text-danger small pt-1 fw-bold">Click Pay Now</a></span>
                                            <span class="text-muted small pt-2 ps-1">for Recharge</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- Customers Card -->
                        <div class="col-12 col-md-6 col-lg-3 mb-3">
                            <div onclick="location.href='{{ route('customer-payment-history') }}'" class="card info-card customers-card">
                                <div class="card-body">
                                    <h5 class="card-title">Payment History</h5>
                                    <div class="d-flex align-items-center">
                                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-table"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6><a href="{{ route('customer-payment-history') }}">Show History</a></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>





                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="row">

                        <!-- Sales Card -->
                        <div class="col-lg-4 col-md-6 mb-3">
                            <div onclick="location.href='{{ route('customerTokenList') }}'" class="card info-card sales-card" style="cursor: pointer;">
                                <div class="card-body">
                                    <h5 class="card-title"><a href="{{ route('customerTokenList') }}">Token <span>| List</span></a></h5>
                                    <div class="d-flex align-items-center">
                                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-card-checklist"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6>{{ $tokenListCount->count() }}</h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- End Sales Card -->

                        <!-- Revenue Card -->
                        <div class="col-lg-4 col-md-6 mb-3">
                            <div onclick="location.href='{{ route('pendingTokenList') }}'" class="card info-card customers-card" style="cursor: pointer;">
                                <div class="card-body">
                                    <h5 class="card-title"><a href="{{ route('pendingTokenList') }}">Pending <span>| Token</span></a></h5>
                                    <div class="d-flex align-items-center">
                                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-hourglass-split"></i>
                                        </div>
                                        <div class="ps-3">
                                            <h6>{{ $pendingTokenCount->count() }}</h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- End Revenue Card -->

                        <!-- Customers Card -->
                        <div class="col-lg-4 col-md-6 mb-4">
                            <div onclick="location.href='{{ route('customer-token.index') }}'" class="card info-card sales-card" style="cursor: pointer;">
                                <div class="card-body">
                                    <h5 class="card-title"><a href="{{ route('customer-token.index') }}">Create <span>| Token</span></a></h5>
                                    <div class="d-flex align-items-center">
                                        <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-bag-plus-fill"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- End Customers Card -->
                        @if (checkSettings('livespeed-client-portal') == 'enable')
                            @include('Customer.customerLiveSpeed')
                        @endif
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="row">

                        <!-- Sales Card -->
                        <div class="col-xxl-4 col-md-4 d-none">
                            <div class="card info-card sales-card">

                                <div class="card-body">
                                    <h5 class="card-title">New Customer <span>| Request</h5>

                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-person-plus"></i>
                                        </div>

                                    </div>
                                </div>

                            </div>
                        </div><!-- End Sales Card -->

                        <!-- Revenue Card -->
                        <div class="col-xxl-4 col-md-4 d-none">
                            <div class="card info-card revenue-card">
                                <div class="card-body">
                                    <h5 class="card-title">Notice Board <span>| Latest</span></h5>

                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-bell-fill"></i>
                                        </div>

                                    </div>
                                </div>

                            </div>
                        </div><!-- End Revenue Card -->

                        <!-- Customers Card -->
                        <div class="col-xxl-4 col-md-4 d-none">

                            <div class="card info-card customers-card">

                                <div class="card-body">
                                    <h5 class="card-title">Complaints and Help Center</h5>

                                    <div class="d-flex align-items-center">
                                        <div
                                            class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                            <i class="bi bi-question-diamond-fill"></i>
                                        </div>

                                    </div>

                                </div>
                            </div>

                        </div><!-- End Customers Card -->


                    </div>
                </div>
            </div>

        </section>

    </main><!-- End #main -->
@endsection
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
    <script>
        function create_UUID() {
            var dt = new Date().getTime();
            var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
                var r = (dt + Math.random() * 16) % 16 | 0;
                dt = Math.floor(dt / 16);
                return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
            });
            return uuid;
        }


        const data = {
            labels: [],
            datasets: [{
                label: 'Downloads',
                backgroundColor: '#333C83',
                borderColor: '#333C83',
                data: [],
                tension: 0.3,


            }, {
                label: 'Uploads',
                backgroundColor: 'rgb(255, 99, 132)',
                borderColor: 'rgb(255, 99, 132)',
                data: [],
                tension: 0.3,


            }]
        };


        const config = {
            type: 'line',
            data: data,
            options: {
                scales: {
                    y: {
                        ticks: {
                            callback: function(value, index, ticks) {
                                return value > 1 ? value + 'Mb' : (value * 1024) + "Kb";
                            }
                        }
                    }
                },
                plugins: {
                    title: {
                        display: true,
                        text: 'Real-Time Speed',
                        padding: {
                            top: 10,
                            bottom: 10
                        },
                        font: {
                            size: 15,

                        }
                    },
                    legend: {
                        labels: {
                            // This more specific font property overrides the global property
                            font: {
                                size: 12
                            }
                        }
                    }
                }
            }
        };

        const myChart = new Chart(
            document.getElementById('myChart'),
            config
        );

        let usageData = [1, 1];
        if (!('{{ $error }}'.length > 0)) {
            usageData = [
                ({{ ($bandwidthUsage ? $bandwidthUsage['tx-byte'] : 1) / 1048576 }}).toFixed(3),
                ({{ ($bandwidthUsage ? $bandwidthUsage['rx-byte'] : 1) / 1048576 }}).toFixed(3),
            ]
        }

        const pieChartData = {
            labels: [
                'Downloads',
                'Uploads',
            ],
            datasets: [{
                label: 'My First Dataset',
                data: usageData,
                backgroundColor: [
                    '#333C83',
                    'rgb(255, 99, 132)',
                ],
                hoverOffset: 4
            }]

        };

        const pieChartConfig = {
            type: 'doughnut',
            data: pieChartData,
        }

        const pieChart = new Chart(
            document.getElementById('pieChart'),
            pieChartConfig
        );

        $('#speedshow').click(function() {
            console.log('clicked');
            $('#speedshow').hide();
            const uuid = create_UUID();


            const currentTime = () => {
                const today = new Date();
                const time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
                return time;
            }

            const addData = (chart, download, upload) => {
                const time = currentTime();

                chart.data.datasets[0].label = download > 1 ? `Download ${download.toFixed(3)} Mbps` :
                    `Download ${(download *1024).toFixed(3)} Kbps`
                chart.data.datasets[1].label = upload > 1 ? `Upload ${upload.toFixed(3)} Mbps` :
                    `Upload ${(upload *1024).toFixed(3)} Kbps`

                chart.data.labels.push(time)
                chart.data.datasets[0].data.push(download);
                chart.data.datasets[1].data.push(upload)
                chart.update();

            }

            function removeData(chart) {
                chart.data.labels.shift();
                chart.data.datasets.forEach((dataset) => {
                    dataset.data.shift();
                });
                chart.update();
            }
            const pusher = new Pusher('{{ config('broadcasting.connections.pusher.key') }}', {
                cluster: '{{ config('broadcasting.connections.pusher.options.cluster') }}'
            });
            const user_id = $('#user_Id').val();
            const admin_user_id = $('#admin_user_Id').val();

            const channel = pusher.subscribe(uuid);

            channel.bind('my-event', function(data) {
                const speed = JSON.parse(JSON.parse(JSON.stringify(data)).message)[0];
                const upload = speed["rx-bits-per-second"] / 1048576;
                const download = speed["tx-bits-per-second"] / 1048576;

                if (myChart.data.datasets[0].data.length > 15) {
                    removeData(myChart);
                }
                addData(myChart, download, upload)

            });

            $(document).ready(function() {
                const user_id = $('#user_Id').val();
                const admin_user_id = $('#admin_user_Id').val();
                $.ajax({
                    type: 'GET',
                    url: '{{ route('getClientSpeed') }}',
                    data: {
                        id: user_id,
                        uuid: uuid,

                    },
                    success: function(data) {
                        $('#speedshow').show();

                    },
                    error: function(request, error) {
                        toastr.error(request.responseText);
                        $('#speedshow').show();
                    }
                });
            });
        });
    </script>
@endsection
