@extends('Customer.customer-layout')

@section('body')
    @include('Customer.left-menu')

    <main id="main" class="main">

        <a href="{{ route('customerDashboard') }}" class="btn-sm bg-dark text-white mb-3"><i class="fa fa-arrow-left"></i>
            Back To
            Dashboard</a>
        <div class="pagetitle mt-2">
            <h1>Bill Pay</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('customerDashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">Bill Pay</li>
                </ol>
            </nav>

        </div><!-- End Page Title -->

        <section class="section profile">
            <div class="table-responsive"">
                <table class="table table-responsive table-bordered">
                    <tr>
                        <th>Paid Amount</th>
                        <th>Description</th>
                        <th>Payment Date</th>
                    </tr>

                    @foreach ($details['paymentinfo'] as $r)
                        <tr>
                            <td class="text-right">
                                {{ $r->paid_amount }}
                            </td>
                            <td>
                                {{ $r->description }}
                            </td>
                            <td>
                                {{ date('d-M-Y h:i:a', strtotime($r->created_at)) }}
                            </td>
                        </tr>
                    @endforeach


                </table>

                <div class="">
                    {{ $details['paymentinfo']->onEachSide(2)->links() }}
                </div>
            </div>
        </section>



    </main>


    </div>
    </div>

    {{-- {{dd($details)}} --}}
@endsection
