@extends('layout.app')


@section('css')
    <!-- DataTables -->
    <link rel="stylesheet" href="{{ asset('admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('content')

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;">Expense Head List</h3>
                            <div class="card-tools">
                                <a href="{{ route('expense.index') }}"><button class="btn btn-sm btn-info"><i
                                    class="fa fa-arrow-left" aria-hidden="true"></i> &nbsp;Expense List</button></a>

                                <a href="{{ route('expense-head.create') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Expense
                                        Head</button></a>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="dataTable" class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Expense Head</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($expenseHeads as $row)
                                        <tr>
                                            <td>{{ $row->id }}</td>
                                            <td>{{ $row->name }}</td>
                                            <td>
                                                @can('expense-section')

                                                    @if (!in_array($row->id, [1, 2, 3, 4, 5, 6]))

                                                        <div class="btn-group">
                                                            <a href="{{ route('expense-head.edit', $row->id) }}"
                                                                class="btn btn-sm btn-primary">
                                                                <i class="fa fa-pencil-square-o"></i>
                                                                Edit
                                                            </a>
                                                        </div>

                                                        {{-- <div class="btn-group">
                                                            <form action="{{ route('expense-head.destroy', $row) }}"
                                                                method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button id="{{ $row->id }}"
                                                                    class="btn btn-sm btn-danger">Delete</button>
                                                            </form>
                                                        </div> --}}
                                                    @endif
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
            <!-- /.row -->
        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
@section('js')

@endsection
@push('script')
    <!-- page script -->

@endpush
