@extends('layout.app')


@section('content')
    <!-- Main content -->
    <section class="content" id="app">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- Horizontal Form -->
                    <div class="card card-body">
                        <div class="card-header bg-light">
                            <div class="card-tools">

                                <button type="button" class="btn btn-primary" data-toggle="modal"
                                    data-target="#modal-fund-transfer">
                                    New Fund Transfer
                                </button>
                            </div>
                        </div>

                        <div class="card-body table-responsive">
                            <table class="table table-bordered table-striped">
                                <tr>
                                    <th>ID</th>
                                    <th>Date</th>
                                    <th>Fund Send By</th>
                                    <th>Fund Received By</th>
                                    <th>Amount</th>
                                    <th>Note</th>
                                    <th></th>
                                </tr>
                                @foreach ($lists as $list)
                                    <tr>
                                        <td>{{ $list->id }}</td>
                                        <td>{{ $list->created_at }}</td>
                                        <td>@if ($list->fund_send_by == 0) Cash @else {{ $all_users->where('id', $list->fund_send_by)->first()->name }} @endif</td>
                                        <td>@if ($list->fund_received_by == 0) Cash @else {{ $all_users->where('id', $list->fund_received_by)->first()->name }} @endif</td>
                                        <td>{{ $list->amount }}</td>
                                        <td>{{ $list->note }}</td>
                                        <td>
                                            <a href="{{route('fund-transfer.edit',$list->id)}}" class="btn btn-info btn-xs"><i class="fa fa-edit"></i></a>

                                        </td>
                                    </tr>
                                @endforeach
                            </table>
                        </div>


                    </div>
                    <!-- /.card -->
                </div>
                <div class="col-2"></div>
            </div>
            <!-- /.row -->

            <div class="modal fade" id="modal-fund-transfer">
                <div class="modal-dialog">
                    <form action="{{ route('fund-transfer.store') }}" method="POST">
                        @csrf
                        @method('post')
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4 class="text-center">Fund Transfer</h4>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <div class="text-center" id="modalAlert"></div>

                                <div class="row">

                                    <div class="col-md-4">Fund Send By</div>
                                    <div class="col-md-8 mb-2">
                                        <select class="form-control select2" name="send_by" id="">
                                            <option value="">Select Send By</option>
                                            <option value="0">CASH</option>
                                            @foreach ($users as $s)
                                                <option value="{{ $s->id }}">{{ $s->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="col-md-4">Fund Received By</div>
                                    <div class="col-md-8 mb-2">
                                        <select class="form-control select2" name="received_by" id="">
                                            <option value="">Select Received By</option>
                                            <option value="0">CASH</option>
                                            @foreach ($users as $s)
                                                <option value="{{ $s->id }}">{{ $s->name }}</option>
                                            @endforeach
                                        </select>
                                        <input type="hidden" name="transfer_type" value="fund_transfer">
                                    </div>

                                    <div class="col-md-4">Transfer Amount</div>
                                    <div class="col-md-8 mb-2">
                                        <input type="number" name="amount" class="form-control">
                                    </div>

                                    <div class="col-md-4">Note</div>
                                    <div class="col-md-8 mb-2">
                                        <textarea name="note" id="note" class="form-control"></textarea>
                                    </div>


                                </div>


                            </div>
                            <div class="modal-footer justify-content-between">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button class="btn btn-primary" type="submit" id="modalSave">Transfer</button>
                            </div>

                        </div>
                        <!-- /.modal-content -->
                    </form>
                </div>
                <!-- /.modal-dialog -->
            </div>



        </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
@section('ajax')

@endsection
