@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Purchase Add</h3>
            <div class="card-tools">
                <a href="{{ route('band-purchase.index') }}"><button class="btn btn-sm btn-primary"><i
                            class="fa fa-arrow-circle-left" aria-hidden="true"></i> &nbsp; Back</button></a>
            </div>
        </div>

        <div class="card-body">
            <form action="{{ route('band-purchase.store') }}" method="POST" class="" id="purchaseForm" enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <div class="col-xl-3 col-md-3 col-12 mb-1">
                        <div class="form-group">
                            <label>Provider</label>
                            <select class="form-control select2" name="provider_id" id="provider_id" required>
                                <option value="">Select One</option>
                                @foreach ($provider as $item)
                                    <option value="{{ $item->id }}">{{ $item->company_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-3 col-12 mb-1" style="display: none">
                        <div class="form-group">
                            <label>Bill No</label>
                            <input type="text" class="form-control" id="bill_no" name="bill_no" readonly>
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-3 col-12 mb-1">
                        <div class="form-group">
                            <label>Invoice No</label>
                            <input type="text" class="form-control" id="invoice_no" name="invoice_no">
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-3 col-12 mb-1">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="billing_date" required>
                                Billing Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="billing_date" value=""
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-md-3">
                        <label for="document" class="block text-sm font-medium text-gray-700">
                            Document
                        </label>
                        <input type="file" name="document" id="document" class="form-control" value="">
                    </div>
                    <div style="margin: auto;width: 60%">
                        <input type="text" class="form-control" id="search" name="product_name_or_bar_code"
                            placeholder="Enter Service Name " autocomplete="off">
                    </div>

                    <div id="productList" style="margin: auto;width: 60%">
                        <ul id="pUl" class="list-unstyled"
                            style="overflow-y: scroll; overflow-x: hidden; max-height: 20vh;">
                        </ul>

                    </div>
                </div>

                <div class="row">
                    <div class="table-responsive">
                        <table id="result" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="padding-left: 2px;padding-right: 2px">Service </th>
                                    <th style="padding-left: 2px;padding-right: 2px">Description</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Quantity</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Rate</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Vat</th>
                                    <th style="padding-left: 2px;padding-right: 2px">From Date</th>
                                    <th style="padding-left: 2px;padding-right: 2px">To Date</th>
                                    {{-- <th style="padding-left: 2px;padding-right: 2px">Status</th> --}}
                                    <th style="padding-left: 2px;padding-right: 2px">Value</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Action</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="col-md-3 float-right">
                            <input type="number" class="form-control" id="subTotal" name="subTotal" autocomplete="off"
                                step=".01" min="0" readonly>
                        </div>
                        <div class="col-md-3 float-right">
                            Sub Total
                        </div>
                        <div class="col-md-3 float-right">
                            <input type="number" class="form-control" id="total_qty" name="total_qty" autocomplete="off"
                                step=".001" min="0" readonly>
                        </div>
                        <div class="col-md-3 float-right">
                            Total Qty
                        </div>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <div class="col-md-3 float-right">
                            <input type="number" class="form-control" id="marketing_total" name="marketing_total"
                                autocomplete="off" value="0" step=".01" min="0">
                        </div>
                        <div class="col-md-3 float-right">
                            Paid
                        </div>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <div class="col-md-3 float-right">
                            <input type="number" class="form-control" id="total" name="total" autocomplete="off"
                                step=".01" min="0" readonly>
                        </div>
                        <div class="col-md-3 float-right">
                            Due
                        </div>
                    </div>
                </div>
                <button class="btn btn-primary waves-effect waves-float waves-light float-right mt-2" type="submit"
                    id="submitButton">Submit
                </button>
            </form>
        </div>
    </div>

    <style>
        li.selected {
            background: #17A2B8 !important;
        }
    </style>
@endsection

@section('ajax')
    <script src="{{ asset('adminlte/js/jquery.validate.js') }}"></script>
    <script>
        const fetchData = (productId) => {
            console.log('cursor', productId);
            searchResult(productId);
        }

        function searchResult(productId) {
            // console.log(productId);

            $.ajax({
                type: 'get',
                url: '{{ route('productinfo') }}',
                data: {
                    data: productId
                },
                success: function(res) {
                    console.log(res);
                    r = res;
                    var check = 0;

                    // console.log('comes',res );
                    $('#result tbody').append('<tr>' +
                        '<td style="padding-left: 2px; align: center; display:none"><input style="width: 90px" class="product_id" value="' +
                        r.id + '" type="number" name="service_id[]" required></td>' +
                        '<td style="padding-left: 2px"><lable style="width: 50px" class="product_name"> ' +
                        r.name + '</td>' +
                        '<td style="padding-left: 2px"><lable style="width: 50px" class="description"> ' + r
                        .description + '</td>' +

                        '<td style="padding-left: 2px; align: center"><input style="width: 90px" class="quantity border-0" value="" type="number" name="quantity[]" min=0 required> </td>' +
                        '<td style="padding-left: 2px; align: center"><input style="width: 90px" class="rate border-0" value="0" type="number" step=".01" name="rate[]" min=0 required></td>' +
                        '<td style="padding-left: 2px"><input style="width: 90px" class="vat border-0" type="number" value="0" name="vat[]" min=0></td>' +

                        '<td style="padding-left: 2px"><input style="width: 150px" class="effDate" type="date" required name="from_date[]"></td>' +
                        '<td style="padding-left: 2px"><input style="width: 150px" class="expDate" type="date" required name="to_date[]"></td>' +

                        '<td style="padding-left: 2px; display:none"><select style="width: 90px" class="rate_per_um" name="status[]" required>' +
                        '<option value="Active">Active</option></select></td>' +

                        '<td style="padding-left: 2px"><input style="width: 90px" class="line_total border-0" min=0 value="" type="number" readonly step=".01" name="line_total[]" required></td>' +
                        '<td><lable style="width: 40px" id="btnCancle" step=".01" class="btn btn-dark float-right">-</lable></td>' +
                        +'</tr>');

                    $('#search').val('');
                    $('#pUl').empty();
                    liSelected = null;
                    index = -1;
                    subTotalAndTotal();
                    $("#result").on("click", "#btnCancle", function() {
                        $(this).closest("tr").remove();
                        subTotalAndTotal();

                    });

                    $('#search').val('');

                    $(".quantity").keyup(function() {
                        all($(this));
                    });

                    $(".rate").keyup(function() {
                        all($(this));
                    });

                    $(".vat").keyup(function() {
                        all($(this));
                    });

                    function all(thisObj) {

                        var qty = thisObj.parents("tr").find("input.quantity").val();
                        var rate = thisObj.parents("tr").find("input.rate").val();
                        var vat = thisObj.parents("tr").find("input.vat").val();

                        var price = parseFloat(rate) * parseFloat(vat);
                        var price_vat = parseFloat(price) / 100;

                        var price_with_vat = parseFloat(price_vat) + parseFloat(rate);

                        var lineTotal = parseFloat(price_with_vat) * parseFloat(qty);

                        console.log(lineTotal);

                        thisObj.parents("tr").find("input.line_total").val(lineTotal.toFixed(2));
                        subTotalAndTotal();

                    }

                    function subTotalAndTotal() {
                        var TotalLineCost = 0;
                        var TotalQty = 0;

                        $("tr .line_total").each(function(index, value) {

                            currentRowLineCost = parseFloat($(this).val());
                            TotalLineCost += parseFloat(currentRowLineCost);
                        });

                        $("tr .quantity").each(function(index, value) {

                            currentRowQty = parseFloat($(this).val());
                            TotalQty += parseFloat(currentRowQty);
                        });

                        $('#subTotal').val(TotalLineCost.toFixed(2));
                        $('#total_qty').val(TotalQty.toFixed(3));

                        var marketing_commision = $('#marketing_total').val();
                        var total = parseFloat(TotalLineCost) - parseFloat(marketing_commision);

                        $('#total').val(total.toFixed(2));
                    }

                }
            });
        }


        $(document).ready(function() {
            var ul = document.getElementById('pUl');
            var liSelected;
            var index = -1;

            $('#marketing_total').keyup(function() {
                subTotalAndTotal();
            });

            function subTotalAndTotal() {
                var TotalLineCost = 0;
                var TotalQty = 0;

                $("tr .line_total").each(function(index, value) {

                    currentRowLineCost = parseFloat($(this).val());
                    TotalLineCost += parseFloat(currentRowLineCost);
                });

                $("tr .quantity").each(function(index, value) {

                    currentRowQty = parseFloat($(this).val());
                    TotalQty += parseFloat(currentRowQty);
                });

                $('#subTotal').val(TotalLineCost.toFixed(2));
                $('#total_qty').val(TotalQty.toFixed(3));

                var marketing_commision = $('#marketing_total').val();
                var total = parseFloat(TotalLineCost) - parseFloat(marketing_commision);

                $('#total').val(total.toFixed(2));
            }

            $('#submitButton').click(function(e) {
                e.preventDefault();
                var rowCount = $("#result tr").length;

                if (rowCount > 1) {
                    $('#purchaseForm').valid();
                    $('#purchaseForm').submit();
                } else {
                    toastr.error('Please Add Service');
                }

            });

            $('#purchaseForm').on('keydown', 'input', function(event) {
                if (event.which == 13) {
                    event.preventDefault();
                }
            });

            $('#search').keyup(function(e) {
                var lent = ul.getElementsByTagName('li').length - 1;
                var searchText = $('#search').val();
                if (e.which == 13) {
                    e.preventDefault();
                    if (liSelected) {
                        var thisProduct = ul.getElementsByTagName('li')[index];
                        var b = thisProduct.querySelector("input.product_id").value;
                        var productname = b;
                        console.log('keyup', productname);
                        searchResult(productname);

                        $('#search').val('');
                        $('#pUl').empty();
                        liSelected = null;
                        index = -1;

                    }
                    var l = $("#pUl li");
                    var len = l.length;
                    if (len == 1) {

                        var thisProduct = ul.getElementsByTagName('li')[0];
                        var b = thisProduct.querySelector("input.product_id").value;
                        var productname = b;

                        console.log('len1', productname);
                        searchResult(productname);

                        $('#search').val('');
                        $('#pUl').empty();
                        liSelected = null;
                        index = -1;

                        $(".quantity").keyup(function() {
                            all($(this));
                        });

                        $(".rate").keyup(function() {
                            all($(this));
                        });

                        $(".vat").keyup(function() {
                            all($(this));
                        });

                        function all(thisObj) {
                            var qty = thisObj.parents("tr").find("input.quantity").val();
                            var rate = thisObj.parents("tr").find("input.rate").val();
                            var vat = thisObj.parents("tr").find("input.vat").val();

                            var price = parseFloat(rate) * parseFloat(vat);
                            var price_vat = parseFloat(price) / 100;

                            var price_with_vat = parseFloat(price_vat) + parseFloat(rate);

                            var lineTotal = parseFloat(price_with_vat) * parseFloat(qty);

                            console.log(lineTotal);

                            thisObj.parents("tr").find("input.line_total").val(lineTotal.toFixed(2));
                        }
                    }
                } else if (e.which === 40) {
                    if (lent >= 0) {
                        index++;
                        if (liSelected) {
                            removeClass(liSelected, 'selected');
                            next = ul.getElementsByTagName('li')[index];
                            if (typeof next !== undefined && index <= lent) {
                                liSelected = next;
                            } else {

                                index = 0;
                                liSelected = ul.getElementsByTagName('li')[0];
                            }
                            addClass(liSelected, 'selected');

                        } else {
                            index = 0;
                            liSelected = ul.getElementsByTagName('li')[0];
                            addClass(liSelected, 'selected');
                        }
                    }

                } else if (e.which === 38) {

                    if (lent >= 0) {
                        e.preventDefault();
                        if (liSelected) {
                            removeClass(liSelected, 'selected');
                            index--;
                            next = ul.getElementsByTagName('li')[index];
                            if (typeof next !== undefined && index >= 0) {
                                liSelected = next;
                            } else {
                                index = lent;
                                liSelected = ul.getElementsByTagName('li')[lent];
                            }
                            addClass(liSelected, 'selected');
                        } else {
                            index = 0;
                            liSelected = ul.getElementsByTagName('li')[lent];
                            addClass(liSelected, 'selected');
                        }
                    }

                } else {
                    data = $('#search').val();
                    if (data.length < 1) {

                        $('#pUl').empty();
                    }
                    if (data.length > 1) {
                        $.ajax({
                            type: 'get',
                            url: '{{ route('productDetails') }}',
                            data: {
                                data: data
                            },
                            success: function(result) {

                                $('#pUl').empty();
                                for (i = 0; i < result.length; i++) {
                                    d = result[i];
                                    $("#pUl").append(
                                        `<li class="list-group-item list-group-item-dark productli" onClick="fetchData(${d.id})">` +
                                        d.name +
                                        '<div class="row">' +
                                        '<div class="col-md-6"><input type="hidden" class="product_id" value="' +
                                        d.id + '" name="reference_no"  >' +
                                        '</div>' +
                                        '</div>' +
                                        '</li>');

                                    liSelected = null;
                                    index = -1;
                                }
                            }
                        });
                    }
                }

                function removeClass(el, className) {
                    if (el.classList) {
                        el.classList.remove(className);
                    } else {
                        el.className = el.className.replace(new RegExp('(^|\\b)' + className.split(' ')
                            .join('|') + '(\\b|$)', 'gi'), ' ');
                    }
                };

                function addClass(el, className) {
                    if (el.classList) {
                        el.classList.add(className);
                    } else {
                        el.className += ' ' + className;
                    }
                };
            });


        });
    </script>
@endsection
