@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Purchase Edit</h3>
            <div class="card-tools">
                <a href="{{ route('band-purchase.index') }}"><button class="btn btn-sm btn-primary"><i
                            class="fa fa-arrow-circle-left" aria-hidden="true"></i> &nbsp; Back</button></a>
            </div>
        </div>

        <div class="card-body">
            <form action="{{ route('band-purchase.update', $purchase) }}" method="POST" class="" id="purchaseForm"
                enctype="multipart/form-data">
                @csrf
                @method('put')
                <div class="row">
                    <input type="hidden" name="id" value="{{ $purchase->id }}">
                    <div class="col-xl-3 col-md-3 col-12 mb-1">
                        <div class="form-group">
                            <label>Provider</label>
                            <select class="form-control select2" name="provider_id" id="provider_id" required>
                                <option value="">Select One</option>
                                @foreach ($provider as $item)
                                    <option value="{{ $item->id }}"
                                        {{ $purchase->provider_id == $item->id ? 'selected' : '' }}>
                                        {{ $item->company_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-2 col-12 mb-1">
                        <div class="form-group">
                            <label>Bill No</label>
                            <input type="text" class="form-control" id="bill_no" name="bill_no"
                                value="{{ $purchase->bill_no }}" readonly>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-2 col-12 mb-1">
                        <div class="form-group">
                            <label>Invoice No</label>
                            <input type="text" class="form-control" id="invoice_no" name="invoice_no"
                                value="{{ $purchase->invoice_no }}">
                            @error('invoice_no')
                                <div class="text-danger mt-2 text-sm ">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-xl-3 col-md-3 col-12 mb-1">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="billing_date" required>
                                Billing Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="billing_date" value="{{ $purchase->billing_date }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-2 col-md-2 col-12 mb-1">
                        <label>Document</label>
                        <div class="form-group">
                            <input type="file" name="document" id="document" class="form-control" value="">
                            @if ($purchase->document != null)
                                <img src="{{ asset('storage/bandPurchase/' . $purchase->document) }}"
                                    style="width: 60px; height: 40px;">
                            @endif
                        </div>
                    </div>
                    {{-- <div style="margin: auto;width: 60%">
                        <input type="text" class="form-control" id="search" name="product_name_or_bar_code"
                            placeholder="Enter Service Name " autocomplete="off">
                    </div>
                    <div id="productList" style="margin: auto;width: 60%">
                        <ul id="pUl" class="list-unstyled"
                            style="overflow-y: scroll; overflow-x: hidden; max-height: 20vh;">
                        </ul>
                    </div> --}}
                    @php
                        $service = App\Models\BandService::all();
                    @endphp
                    <div class="col-md-4 mb-5">
                        <label>Select Service</label>
                        <select class="form-control " id="serviceId">
                            <option value="">Select One</option>
                            @foreach ($service as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="row">
                    <div class="table-responsive">
                        <table id="result" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="padding-left: 2px;padding-right: 2px">Service </th>
                                    <th style="padding-left: 2px;padding-right: 2px">Description</th>
                                    <th style="padding-left: 2px;padding-right: 2px">From Date</th>
                                    <th style="padding-left: 2px;padding-right: 2px">To Date</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Quantity</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Rate</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Vat</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Status</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Value</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($purchase->purchaseItem as $item)
                                    <tr>
                                        <td style="padding-left: 2px; align: center; display:none">
                                            <input style="width: 90px" class="product_id" value="{{ $item->service_id }}"
                                                type="number" name="service_id[]" required>
                                        </td>
                                        <td style="padding-left: 2px; align: center; display:none">
                                            <input style="width: 90px" class="purchase_item_id" value="{{ $item->id }}"
                                                type="number" name="purchase_item_id[]" required>
                                        </td>
                                        <td style="padding-left: 2px">
                                            <lable style="width: 50px" class="product_name">
                                                {{ $item->service->name ?? '' }}</lable>
                                        </td>
                                        <td style="padding-left: 2px">
                                            <lable style="width: 50px" class="description">
                                                {{ $item->service->description ?? '' }}</lable>
                                        </td>
                                        <td style="padding-left: 2px">
                                            <input style="width: 150px" class="effDate" type="date"
                                                value="{{ $item->from_date ?? '' }}" required name="from_date[]">
                                        </td>
                                        <td style="padding-left: 2px">
                                            <input style="width: 150px" class="expDate" type="date"
                                                value="{{ $item->to_date ?? '' }}" required name="to_date[]">
                                        </td>
                                        <td style="padding-left: 2px; align: center">
                                            <input style="width: 90px" class="quantity border-0"
                                                value="{{ $item->quantity ?? '' }}" type="number" name="quantity[]"
                                                min=0 required>
                                        </td>
                                        <td style="padding-left: 2px; align: center">
                                            <input style="width: 90px" class="rate border-0"
                                                value="{{ $item->rate ?? '' }}" type="number" step=".01"
                                                name="rate[]" min=0 required>
                                        </td>
                                        <td style="padding-left: 2px">
                                            <input style="width: 90px" class="vat border-0" type="number"
                                                value="{{ $item->vat ?? '' }}" name="vat[]" min=0>
                                        </td>

                                        <td style="padding-left: 2px;">
                                            <select style="width: 90px" class="rate_per_um" name="status[]" required>
                                                <option value=""> </option>
                                                <option value="Active" {{ $item->status == 'Active' ? 'selected' : '' }}>
                                                    Active</option>
                                                <option value="Deactive"
                                                    {{ $item->status == 'Deactive' ? 'selected' : '' }}>Deactive</option>
                                            </select>
                                        </td>
                                        @php
                                            $value = 0;
                                            $price = $item->rate * $item->vat;
                                            $price_vat = $price / 100;
                                            $price_with_vat = $price_vat + $item->rate;
                                            $value = $price_with_vat * $item->quantity;
                                        @endphp
                                        <td style="padding-left: 2px">
                                            <input style="width: 90px" class="line_total border-0" min=0
                                                value="{{ $value }}" type="number" readonly step=".01"
                                                name="line_total[]" required>
                                        </td>
                                        <td>
                                            <lable style="width: 40px" id="btnCancle" step=".01"
                                                class="btn btn-dark float-right">-</lable>
                                        </td>

                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="col-md-3 float-right">
                            <input type="number" class="form-control" id="subTotal" name="subTotal"
                                value="{{ $purchase->subTotal }}" autocomplete="off" min="0" readonly>
                        </div>
                        <div class="col-md-3 float-right">
                            Sub Total
                        </div>
                        <div class="col-md-3 float-right" style="display: none">
                            <input type="number" class="form-control" id="total_qty" name="total_qty"
                                value="{{ $purchase->total_qty }}" autocomplete="off" step=".001" min="0"
                                readonly>
                        </div>
                        <div class="col-md-3 float-right" style="display: none">
                            Total Qty
                        </div>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <div class="col-md-3 float-right">
                            <input type="number" class="form-control" id="marketing_total" name="marketing_total"
                                autocomplete="off" value="{{ $purchase->marketing_total }}" step=".01"
                                min="0">
                        </div>
                        <div class="col-md-3 float-right">
                            Paid
                        </div>
                    </div>
                </div>
                @php
                    $total = $purchase->subTotal - $purchase->marketing_total;
                @endphp
                <div class="row mt-2">
                    <div class="col-md-12">
                        <div class="col-md-3 float-right">
                            <input type="number" class="form-control" id="total" name="total" autocomplete="off"
                                value="{{ $total }}" step=".01" min="0" readonly>
                        </div>
                        <div class="col-md-3 float-right">
                            Due
                        </div>
                    </div>
                </div>
                <button class="btn btn-primary waves-effect waves-float waves-light float-right mt-2" type="submit"
                    id="submitButton">Update
                </button>
            </form>
        </div>
    </div>

    <style>
        li.selected {
            background: #17A2B8 !important;
        }
    </style>
@endsection

@section('ajax')
    <script src="{{ asset('adminlte/js/jquery.validate.js') }}"></script>


    <script>
        const fetchData = (productId) => {
            console.log(productId);
            searchResult(productId);
        }

        $('#serviceId').change(() => {
            console.log($('#serviceId').val());
            var serviceSelect = $('#serviceId').val();

            fetchData(serviceSelect);
        });

        function all(thisObj) {
            var qty = thisObj.parents("tr").find("input.quantity").val();
            var rate = thisObj.parents("tr").find("input.rate").val();
            var vat = thisObj.parents("tr").find("input.vat").val();

            var from = new Date(thisObj.parents("tr").find("input.effDate").val());
            var to = new Date(thisObj.parents("tr").find("input.expDate").val());
            var diffTime = Math.abs(to - from);
            var diffDay = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
            var days = diffDay + 1;
            var month = days / 30;

            var price = parseFloat(rate) * parseFloat(vat);
            var price_vat = parseFloat(price) / 100;
            var price_with_vat = parseFloat(price_vat) + parseFloat(rate);
            var lineTotal = parseFloat(price_with_vat) * parseFloat(qty) * month;

            console.log(lineTotal);
            thisObj.parents("tr").find("input.line_total").val(lineTotal.toFixed(2));
            subTotalAndTotal();
        }

        function subTotalAndTotal() {
            var TotalLineCost = 0;
            var TotalQty = 0;

            $("tr .line_total").each(function(index, value) {
                currentRowLineCost = parseFloat($(this).val());
                TotalLineCost += parseFloat(currentRowLineCost);
            });

            $("tr .quantity").each(function(index, value) {
                currentRowQty = parseFloat($(this).val());
                TotalQty += parseFloat(currentRowQty);
            });

            $('#subTotal').val(TotalLineCost.toFixed(2));
            $('#total_qty').val(TotalQty.toFixed(3));

            var marketing_commision = $('#marketing_total').val();
            var total = parseFloat(TotalLineCost) - parseFloat(marketing_commision);

            $('#total').val(total.toFixed(2));
        }

        function calCall() {
            $(".effDate").change(function() {

                var from_date = new Date($(this).parents("tr").find("input.effDate").val());
                var dd = String(from_date.getDate()).padStart(2, '0');
                var mm = String(from_date.getMonth() + 1).padStart(2, '0');
                var yyyy = from_date.getFullYear();
                from_date = yyyy + '-' + mm + '-' + dd;
                $('.expDate').attr('min', from_date);

                all($(this));
            });
            $(".expDate").change(function() {
                all($(this));
            });
            $(".quantity").keyup(function() {
                all($(this));
            });

            $(".rate").keyup(function() {
                all($(this));
            });

            $(".vat").keyup(function() {
                all($(this));
            });
        }

        function searchResult(productId) {
            $.ajax({
                type: 'get',
                url: '{{ route('productinfo') }}',
                data: {
                    data: productId
                },
                success: function(res) {
                    r = res;
                    var check = 0;

                    var id = $('#serviceId').val();
                    $("tr .product_id").each(function(index, value) {
                        currentId = parseFloat($(this).val());
                        if (id == currentId) {
                            check = 1;
                            // console.log('Duplicate id');
                        }
                    });
                    if (check == 0) {

                        $('#result tbody').append('<tr>' +
                            '<td style="padding-left: 2px; align: center; display:none"><input style="width: 90px" class="product_id" value="' +
                            r.id + '" type="number" name="service_id[]" required></td>' +
                            '<td style="padding-left: 2px"><lable style="width: 50px" class="product_name"> ' +
                            r.name + '</td>' +
                            '<td style="padding-left: 2px"><lable style="width: 50px" class="description"> ' +
                            r
                            .description + '</td>' +

                            '<td style="padding-left: 2px"><input style="width: 150px" class="effDate" type="date" required name="from_date[]"></td>' +
                            '<td style="padding-left: 2px"><input style="width: 150px" class="expDate" type="date" required name="to_date[]"></td>' +

                            '<td style="padding-left: 2px; align: center"><input style="width: 90px" class="quantity border-0" value="" type="number" name="quantity[]" min=0 required> </td>' +
                            '<td style="padding-left: 2px; align: center"><input style="width: 90px" class="rate border-0" value="0" type="number" step=".01" name="rate[]" min=0 required></td>' +
                            '<td style="padding-left: 2px"><input style="width: 90px" class="vat border-0" type="number" value="0" name="vat[]" min=0></td>' +

                            '<td style="padding-left: 2px"><select style="width: 90px" class="rate_per_um" name="status[]" required>' +
                            '<option value="Active">Active</option> <option value="Deactive">Deactive</option></select></td>' +
                            '<td style="padding-left: 2px"><input style="width: 90px" class="line_total border-0" min=0 value="" type="number" readonly step=".01" name="line_total[]" required></td>' +
                            '<td><lable style="width: 40px" id="btnCancle" step=".01" class="btn btn-dark float-right">-</lable></td>' +
                            +'</tr>');

                    } else {
                        // console.log("Same ID selected");
                        toastr.error('You have seleceed Same Service');
                    }

                    $('#search').val('');
                    $('#pUl').empty();
                    liSelected = null;
                    index = -1;
                    subTotalAndTotal();
                    $("#result").on("click", "#btnCancle", function() {
                        $(this).closest("tr").remove();
                        subTotalAndTotal();

                    });

                    $('#search').val('');

                    calCall();

                }
            });
        }

        $(document).ready(function() {
            var ul = document.getElementById('pUl');
            var liSelected;
            var index = -1;

            $("#result").on("click", "#btnCancle", function() {
                $(this).closest("tr").remove();
                subTotalAndTotal();

            });

            calCall();

            $('#marketing_total').keyup(function() {
                subTotalAndTotal();
            });

            $('#submitButton').click(function(e) {
                e.preventDefault();
                var rowCount = $("#result tr").length;

                if (rowCount > 1) {
                    $('#purchaseForm').valid();
                    $('#purchaseForm').submit();
                } else {
                    toastr.error('Please Add Product');
                }

            });

            $('#purchaseForm').on('keydown', 'input', function(event) {
                if (event.which == 13) {
                    event.preventDefault();
                }
            });

            $('#search').keyup(function(e) {
                var lent = ul.getElementsByTagName('li').length - 1;
                var searchText = $('#search').val();

                if (e.which == 13) {

                    e.preventDefault();
                    if (liSelected) {
                        var thisProduct = ul.getElementsByTagName('li')[index];
                        var b = thisProduct.querySelector("input.product_id").value;
                        var productname = b;

                        searchResult(productname);

                        $('#search').val('');
                        $('#pUl').empty();
                        liSelected = null;
                        index = -1;

                    }
                    var l = $("#pUl li");
                    var len = l.length;
                    if (len == 1) {

                        var thisProduct = ul.getElementsByTagName('li')[0];
                        var b = thisProduct.querySelector("input.product_id").value;
                        var productname = b;

                        searchResult(productname);

                        $('#search').val('');
                        $('#pUl').empty();
                        liSelected = null;
                        index = -1;

                        calCall();

                    }
                } else if (e.which === 40) {

                    if (lent >= 0) {
                        index++;
                        if (liSelected) {
                            removeClass(liSelected, 'selected');
                            next = ul.getElementsByTagName('li')[index];
                            if (typeof next !== undefined && index <= lent) {
                                liSelected = next;
                            } else {

                                index = 0;
                                liSelected = ul.getElementsByTagName('li')[0];
                            }
                            addClass(liSelected, 'selected');

                        } else {
                            index = 0;
                            liSelected = ul.getElementsByTagName('li')[0];
                            addClass(liSelected, 'selected');
                        }
                    }

                } else if (e.which === 38) {

                    if (lent >= 0) {
                        e.preventDefault();
                        if (liSelected) {
                            removeClass(liSelected, 'selected');
                            index--;
                            next = ul.getElementsByTagName('li')[index];
                            if (typeof next !== undefined && index >= 0) {
                                liSelected = next;
                            } else {
                                index = lent;
                                liSelected = ul.getElementsByTagName('li')[lent];
                            }
                            addClass(liSelected, 'selected');
                        } else {
                            index = 0;
                            liSelected = ul.getElementsByTagName('li')[lent];
                            addClass(liSelected, 'selected');
                        }
                    }

                } else {

                    data = $('#search').val();
                    if (data.length < 1) {

                        $('#pUl').empty();
                    }
                    if (data.length > 1) {
                        $.ajax({
                            type: 'get',
                            url: '{{ route('productDetails') }}',
                            data: {
                                data: data
                            },
                            success: function(result) {

                                $('#pUl').empty();
                                for (i = 0; i < result.length; i++) {
                                    d = result[i];
                                    $("#pUl").append(
                                        `<li class="list-group-item list-group-item-dark productli" onclick="fetchData(${d.id})">` +
                                        d.name +
                                        '<div class="row">' +
                                        '<div class="col-md-6"><input type="hidden" class="product_id" value="' +
                                        d.id + '" name="reference_no"  >' +
                                        '</div>' +
                                        '</div>' +
                                        '</li>');

                                    liSelected = null;
                                    index = -1;
                                }
                            }
                        });
                    }
                }

                function removeClass(el, className) {
                    if (el.classList) {
                        el.classList.remove(className);
                    } else {
                        el.className = el.className.replace(new RegExp('(^|\\b)' + className.split(' ')
                            .join('|') + '(\\b|$)', 'gi'), ' ');
                    }
                };

                function addClass(el, className) {
                    if (el.classList) {
                        el.classList.add(className);
                    } else {
                        el.className += ' ' + className;
                    }
                };
            });

        });
    </script>
@endsection
