@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Service Edit</h3>
            <div class="card-tools">
                <a href="{{ route('band-service.index') }}"><button class="btn btn-sm btn-primary">Back</button></a>
            </div>
        </div>

        <form action="{{ route('band-service.update', $service->id) }}" method="POST">
            @method('put')
            @csrf

            <input type="hidden" name="id" value="{{ $service->id }}">
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-md-6">
                        <label for="name" class="block text-sm font-medium text-gray-700">
                            Name
                        </label>
                        <input type="text" name="name" id="name" value="{{ $service->name }}"
                            class="form-control" placeholder="Name" autocomplete="off" required>
                        @error('name')
                            <div class="text-danger mt-2 text-sm ">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-6">
                        <label for="description" class="block text-sm font-medium text-gray-700">
                            Description
                        </label>
                        <textarea name="description" class="form-control">{{ $service->description }}</textarea>
                    </div>

                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">
                        Update
                    </button>
                </div>
            </div>
        </form>
    </div>
@endsection
