@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Customer Edit</h3>
            <div class="card-tools">
                <a href="{{ route('bw-customer.index') }}"><button class="btn btn-sm btn-primary">Back</button></a>
            </div>
        </div>
        <form action="{{ route('bw-customer.update', $customer->id) }}" method="POST" enctype="multipart/form-data">
            @method('put')
            @csrf

            <div class="card-body">
                <div class="row">
                    <input type="hidden" name="id" value="{{ $customer->id }}">
                    <div class="form-group col-md-4">
                        <label for="customer_name" class="block text-sm font-medium text-gray-700">
                            Customer Name
                        </label>
                        <input type="text" name="customer_name" id="customer_name" value="{{$customer->customer_name}}" class="form-control"
                            placeholder="Customer Name" autocomplete="off" required="">
                    </div>
                    <div class="form-group col-md-4">
                        <label for="phone" class="block text-sm font-medium text-gray-700">
                            Mobile Number
                        </label>
                        <input type="text" name="phone" id="phone" class="form-control"
                            placeholder="Phone Number must be 11 digit" value="{{$customer->phone}}" autocomplete="off" required="">
                    </div>
                    <div class="form-group col-md-4">
                        <label for="email" class="block text-sm font-medium text-gray-700">
                            Email
                        </label>
                        <input type="email" name="email" id="email"
                            class="@error('email') is-invalid @enderror form-control" placeholder="Email" value="{{$customer->email}}"
                            autocomplete="off" required="">
                    </div>
                    <div class="form-group col-md-4">
                        <label for="contact_person" class="block text-sm font-medium text-gray-700">
                            Contact Person
                        </label>
                        <input type="text" name="contact_person" id="contact_person" class="form-control"
                            placeholder="Contact Person" value="{{$customer->contact_person}}" autocomplete="off" required="">
                    </div>
                    <div class="form-group col-md-4">
                        <label for="reference_by" class="block text-sm font-medium text-gray-700">
                            Reference By
                        </label>
                        <input type="text" name="reference_by" id="reference_by" class="form-control"
                            placeholder="Reference By" value="{{$customer->reference_by}}">
                    </div>
                    <div class="form-group col-md-4">
                        <label for="remarks" class="block text-sm font-medium text-gray-700">
                            Remarks
                        </label>
                        <input type="text" name="remarks" id="remarks" class="form-control" placeholder="Remarks"
                            value="{{$customer->remarks}}">
                    </div>
                    <div class="form-group col-md-12">
                        <label for="address" class="block text-sm font-medium text-gray-700">
                            Address
                        </label>
                        <textarea name="address" id="address" class="form-control">{{$customer->address}}</textarea>
                    </div>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">
                        Update
                    </button>
                </div>
            </div>
        </form>
    </div>
@endsection
