@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Sale Invoice List</h3>
            <div class="card-tools">
                <a href="{{ route('bw-sale.create') }}"><button class="btn btn-sm btn-primary"><i class="fa fa-plus-circle"
                            aria-hidden="true"></i> &nbsp; Invoice</button></a>
            </div>
        </div>

        <div class="card-body">

            <div class="table-responsive">
                <table id="dataTable" class="display table table-bordered table-striped">
                    <thead class="bg-gray-50">
                        <tr>
                            <th> SL </th>
                            <th> Invoice </th>
                            <th> Customer </th>
                            <th> B Date </th>
                            <th> Subtotal </th>
                            <th> Paid </th>
                            <th> Due </th>
                            <th> Status </th>
                            <th style="width: 100px; "> Action </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach ($list as $row)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $row->invoice_no }}</td>
                                <td>{{ $row->customer_id }}</td>
                                <td>{{ $row->billing_date }}</td>
                                <td>{{ $row->subTotal }}</td>
                                <td>{{ $row->marketing_total }}</td>
                                <td>{{ $row->total }}</td>
                                <td>{{ $row->repeat_invoice }}</td>
                                <td style="">
                                    <div class="row">
                                        <div>
                                            <a href="" class="btn btn-primary">Edit</a>
                                        </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
