@extends('layout.app')


@section('content')
    @foreach ($list as $r)
        <div class="card">
            <div class="card-body">



                <div class="label label-info">
                    <h4 class="p-2 inline-block">{{ $page_title }} ({{ $r->clients_status }})

                        @can('money-receipt-entry')
                            @if ($r->client_approval == 'approved')
                                @include('billing.extra.paymentModal')
                            @endif
                        @endcan


                    </h4>
                </div>


                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr style="background:#78716C !important; color:white;">
                                <th class="col-md-1">ID</th>
                                <th class="col-md-1">Name</th>
                                <th class="col-md-1">User ID</th>
                                <th class="col-md-1">Address</th>
                                <th class="col-md-1">Mobile No</th>
                                <th class="col-md-1">Speed</th>
                                <th class="col-md-1">Taka</th>
                                <th class="col-md-1">C. Date</th>
                                <th class="col-md-1">E. Date</th>
                                <th class="col-md-1">Pop/Zone</th>
                                <th class="col-md-1">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    @php(printf('CID%04d', $r->id))
                                </td>
                                <td>{{ $r->clients_name }}</td>
                                <td>{{ $r->userid }}</td>
                                <td>Flat No: {{ $r->flat_no ?? '' }} ,
                                    Building Name: {{ $r->building_name ?? '' }} ,
                                    Road No: {{ $r->road_no ?? '' }} ,
                                    Block/Sector: {{ $r->block_sector ?? '' }} ,
                                    Area : {{ $r->area ?? '' }},
                                    Box : {{ $r->box ?? '' }}
                                </td>
                                <td>{{ $r->contact_no }}</td>
                                <td>{{ $r->package_name }}</td>

                                <td>Rate: {{ $r->package_rate }}
                                    @if (checkSettings('parmanent_discount') == 'enable')
                                        <hr>
                                        P Dis: {{ $r->parmanent_discount }}
                                    @endif
                                </td>
                                <td>{{ date('d-M-Y', strtotime($r->created_at)) }}</td>
                                <td id="cExpDate">{{ date('d-M-Y', strtotime($r->expire_date)) }}</td>
                                <td class="text-center">{{ $r->popname }}</td>

                                <td>

                                    @if ($r->bill_generate == 'yes' && getBillingType() != 'day_to_day')
                                        <form action="{{ route('billgenerate') }}" method="post">
                                            @csrf
                                            <input name="id" type="hidden" value="{{ $r->id }}">
                                            <button onclick="return confirm('Are you sure you want to Generate Bill?');"
                                                class="btn btn-info btn-sm" type="submit">Generate Monthly Bill</button>
                                        </form>
                                    @endif


                                    @can('add_other_bill')
                                    @include('billing.extra.addBill')
                                    @endcan

                                    <hr>
                                    @can('customer-balance-adjust')
                                        @if ($r->client_approval == 'approved')
                                            @include('billing.extra.customerBalanceAdjustModal')
                                        @endif
                                    @endcan
                                    <hr class="clearfix">

                                    <a href="{{ route('clients.edit', $r->id) }}"
                                        class="btn btn-success btn-xs btn-block">Edit</a>

                                    @if ($r->client_approval == 'approved')
                                        @if ($r->clients_status != 'deactive')
                                            @can('customer-deactivated')
                                                {{-- <a href="{{ route('idDeactive', $r->id) }}"
                                                    onclick="return confirm('Are you sure you want to Deactive the ID?');"
                                                    class="btn btn-danger btn-block btn-xs">Deactive</a> --}}
                                                {{-- <button type="button"
                                                    onclick="return confirm('Are you sure you want to Deactive the ID?');"
                                                    class="btn btn-danger id_deactive btn-block btn-xs">Deactive</button> --}}
                                                    <a href="#"
                                                        data-id="{{ $r->id }}"
                                                        id="deactive{{$r->id}}"
                                                        class="id_deactive deactive{{ $r->id }} btn btn-danger btn-block btn-xs">Deactive
                                                    </a>
                                            @endcan
                                        @else
                                            @can('customer-reactivate')
                                                {{-- <a href="{{ route('statusChange', ['reactive', $r->id]) }}"
                                                    onclick="return confirm('Are you sure you want to Reactive the ID?');"
                                                    class="btn btn-success btn-block btn-xs">Reactive</a> --}}
                                                    <a href="#"
                                                        data-id="{{ $r->id }}"
                                                        id="deactive{{$r->id}}"
                                                        class="id_reactive reactive{{ $r->id }} btn btn-success btn-block btn-xs">Reactive
                                                    </a>
                                            @endcan
                                        @endif
                                    @endif
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        @if ($r->bill_generate == 'yes')
            <div class="card">
                <div class="card-header">
                    <h2 class="text-center">Payment Information</h2>
                </div>
                <div class="card-body">
                    <table class="table table-bordered">
                        <tr >
                            <td class="text-bold">Service Amount</td>
                            <td class="text-bold">Paid Amount</td>
                            <td class="text-bold">Current Balance</td>
                            <td class="text-bold">OTC Due</td>
                            <td class="text-bold">Total Due Amount</td>
                        </tr>
                        <tr>
                            <td>
                                <p class="alert alert-info">{{ $r->package_rate }}</p>
                            </td>
                            <td>
                                <p id="totalPaidAmount" class="alert alert-info">{{ $r->totalPaid }}</p>
                            </td>
                            <td>
                                <p id="totalCurrentAmount" class="alert alert-info">
                                    @if ($r->dueAmount < 0)
                                        {{ abs($r->dueAmount) ?? 0 }}
                                    @else
                                        {{ 0 }}
                                    @endif
                                </p>
                            </td>
                            <th>
                                <p id="totalOtcAmount" class="alert alert-info listOtcDue{{ $r->id }}">
                                    {{ $r->otc_due ?? 0 }}</p>
                            </th>
                            <td>
                                <p id="TotalDueAmount" class="alert alert-info">
                                    @if ($r->dueAmount < 0)
                                        {{ 0 }}
                                    @else
                                        {{ $r->dueAmount }}
                                    @endif
                                </p>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        @endif
    @endforeach

    <div class="card">

        <div class="row">




            <div class="col-md-7" id="paymentHistoryTable">

            </div>

            <div class="col-md-5">
                <h2 class="header text-center">Bill History</h2>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>Id</th>
                                <th>Description</th>
                                <th>Date</th>
                                <th>Amount</th>

                            </tr>
                            @foreach ($bill_history->get() as $history)
                                <tr class="{{$history->deleted_at ? 'opacity-50' : ''}}">
                                    <td>
                                        @if (
                                            (auth()->user()->id == 1 ||
                                                auth()->user()->can('delete-generated-bill-full-permission')) &&
                                                $history->billing_type != 'deleted')
                                            <a onclick="return confirm('Are you sure you want to Delete?');"
                                                class="btn btn-danger btn-xs"
                                                href="{{ route('billDelete', $history->id) }}">Delete</a>
                                        @elseif (
                                            $history->created_at >= today()->firstOfMonth() &&
                                                $history->created_at <=
                                                    today()->lastofMonth()->addDays(1) &&
                                                $history->billing_type != 'deleted')
                                            @can('delete-generated-bill')
                                                <a onclick="return confirm('Are you sure you want to Delete?');"
                                                    class="btn btn-danger btn-xs"
                                                    href="{{ route('billDelete', $history->id) }}">Delete</a>
                                            @endcan
                                        @endif

                                        {{ $history->id }}
                                    </td>
                                    <td>{{ $history->description }}
                                        @if ($history->deleted_at)
                                            <br>
                                            <span class="badge badge-danger">Deleted BY:
                                                {{ user_list()->where('id',$history->deleted_by)->first()->name }}</span><br>
                                            <span class="badge badge-danger">Delete Time:
                                                {{ $history->deleted_at }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $history->created_at }}</td>
                                    <td>{{ $history->bill_amount }}</td>


                                </tr>
                            @endforeach
                            <tr>
                                <td colspan="3">Total</td>
                                <td>{{ $bill_history->sum('bill_amount') }}TK</td>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>

            @can('customer-balance-adjust')
                <div class="col-md-6">

                    <h2 class="header text-center">Last 10 Balance Adjustment History</h2>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Description</th>
                                    <th>Date</th>
                                    <th>Adjust by</th>
                                    <th>Amount</th>
                                </tr>
                                @foreach ($balance_adjustment->get() as $history)
                                    <tr>
                                        <td>
                                            {{-- @if (auth()->user()->id == 1)
                                                <a class="btn btn-danger"
                                                    href="{{ route('billDelete', $history->id) }}">Delete</a>
                                            @endif --}}

                                            {{ $history->id }}
                                        </td>
                                        <td>{{ $history->description }}</td>
                                        <td>{{ $history->created_at }}</td>
                                        <td>{{ $history->user->name }}</td>
                                        <td>{{ $history->amount }}</td>

                                    </tr>
                                @endforeach
                                <tr>
                                    <td colspan="4">Total</td>
                                    <td>{{ $balance_adjustment->sum('amount') }}TK</td>
                                </tr>
                            </thead>
                        </table>
                    </div>

                </div>
            @endcan
        </div>

    </div>

    <div id="paymenthistory" class="mt-10">


    </div>







@endsection


@section('ajax')
    <style>
        label {
            font-size: 15px !important;
        }
    </style>
    <script>
        $(function() {

            $.get('/admin/paymentLog/' + {{ $r->id }}, function(data) {
                $('#paymentHistoryTable').html(data);
            });

            $('.buttonHide').on('click', function() {
                // $(this).hide();
            });

            $('.paymentButton').on('click', function() {
                $('.buttonHide').show();
            });

            $('#payment_month').on('change', function() {
                var month = $('#payment_month').val();
                @if (checkSettings('payment_month_show_in_remark') == 'enable')
                    $('#description').val(month);
                @else
                    $('#description').val('Payment of month : ' + month + '. Bill Month : ' + month);
                @endif
            });

            $('#payment_type').on('change', function() {
                let type = $(this).val();
                if (type == 2) {
                    let otc_due = {{ $r->otc_due ?? 0 }};
                    $('#in_amount').attr({
                        "max": otc_due
                    });
                    $('#in_amount').val(otc_due);
                } else {
                    $('#in_amount').removeAttr("max");
                    $('#in_amount').val(0);
                }
            });

        });
    </script>
@endsection
