@extends('layout.app')
@section('content')

<div class="card">
    <div class="card-body">
    @can('view-customer-amount')
        <a href="#" class="noprint btn btn-info">Total Customer: {{ $list->count() }}</a>
        <a href="#" class="noprint btn btn-info">Total Amount: {{ $list->map(function ($item) { return $item->customerAccount->dueAmount; })->sum() }}</a>
    @endcan
        <button type="submit" class="btn btn-info float-right mb-2">
            <a class="text-white" href="{{ route('billCollectionPrint') }}" target="blank"> Print</a>
        </button>


        <div class="table-responsive">
                    <table id="dataTable" class="display ">
                        <thead class="bg-gray-50">
                            <tr>
                                <th style="display: none">Invoice</th>
                                <th>ID</th>
                                <th>Username</th>
                                <th>Status</th>
                                <th>Name</th>
                                <th>Contact</th>
                                <th>Address</th>
                                <th>Zone/POP</th>
                                <th>Package</th>
                                <th style="width:100px">Exp. Date</th>
                                {{-- <th>Bill Date</th> --}}
                                <th>OTC</th>
                                <th>Pre_Due</th>
                                <th>Bill</th>
                                <th>Total_Due</th>
                                <th>

                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">

                            @foreach ($list as $r)
                            <tr>
                                <td style="display: none">
                                    <a href="{{ route('severalPrint',$r->id) }}"> <i class="fa fa-print"></i> </a>
                                </td>
                                <td>
                                    <a class="underline text-blue-300"
                                        href="{{route('getPaymentHistory',$r->id)}}">@php(printf("CID%04d",$r->id))</a>

                                        <a href="{{route('invoice',$r->id)}}" class="btn btn-info btn-xs">Invoice</a>
                                </td>
                                <td>
                                    {{ $r->userid }}
                                </td>
                                <td class="cStatus{{ $r->id }} {{ clientStatusClass($r->clients_status) }}">
                                    @if ($r->clients_status == 'active')
                                        Active
                                    @elseif($r->clients_status == 'deactive')
                                        Deactive</span>
                                    @elseif($r->clients_status == 'expired')
                                        Expired</span>
                                    @elseif($r->clients_status == 'disable')
                                        Disabled</span>
                                    @endif
                                </td>
                                <td class="whitespace-nowrap">
                                    {{$r->clientsinfo->clients_name ?? ''}}

                                </td>


                                <td>
                                    {{$r->clientsinfo->contact_no ?? ''}}
                                </td>

                                <td>
                                    Flat No: {{$r->clientsinfo->flat_no ?? ''}} ,
                                    Building Name: {{ $r->clientsinfo->building_name ?? ''}} ,
                                    Road No: {{ $r->clientsinfo->road_no ?? '' }} ,
                                    Block/Sector: {{ $r->clientsinfo->block_sector ?? '' }} ,
                                    Area : {{ $r->clientsinfo->area ?? '' }}

                                </td>

                                <td style="width:100px;">
                                    {{ $r->pop->popname }}
                                </td>

                                <td style="width:100px;">
                                    {{ $r->packages->package_name }}
                                </td>

                                <td class="whitespace-nowrap" style="width:100px">
                                    {{ date('d-M-Y',strtotime($r->expire_date)) }}
                                </td>

                                {{-- <td class="whitespace-nowrap">
                                    {{ date('d-M-Y',strtotime($r->expire_date)) }}

                                    @if($r->totalBillAmount > $r->package_rate)
                                    {{ date('d-M-Y',strtotime($r->expire_date)) }}
                                    @else
                                    {{ date('d-M-Y',strtotime($r->created_at)) }}
                                    @endif
                                </td> --}}
                                <td style="text-align: right">{{ $r->clientsinfo->otc_due }}</td>

                                <td style="text-align: right">
                                    @if($r->customerAccount->dueAmount - $r->packages->package_rate > 0)
                                    {{  $r->customerAccount->dueAmount - $r->packages->package_rate }}
                                    @else
                                    {{ 0 }}
                                    @endif


                                </td>
                                <td style="text-align: right">
                                    {{ $r->packages->package_rate }}
                                </td>
                                <td style="text-align: right">
                                    {{ $r->customerAccount->dueAmount }}
                                </td>



                                <td class="px-6 text-center text-sm font-medium">
                                    @can('payment_create')
                                    @if( $r->customerAccount->dueAmount >= $r->packages->package_rate )
                                    {{-- <form method="post" action="#" class="oneclicksingleform block">
                                        @csrf
                                        <input type="hidden" value="{{$r->id}}" name="id">
                                        <button data-id="{{$r->id}}" type="button"
                                            class="singlePayment btn{{$r->id}} btn btn-danger btn-block mb-1">Bill
                                            Pay</button>
                                    </form> --}}
                                    @endif
                                    @endcan


                                    {{-- <a href="{{ route('singlePayment',$r->id) }}" class="bg-red-600
                                    hover:bg-red-900 rounded text-white py-1 px-2 m-1 block box-border"
                                    onclick="return confirm('Please confirm you want to payment bill. OK or
                                    Cancel.')">Bill Pay</a> --}}

                                    @can('money-receipt-entry')
                                    {{-- <a href="{{ route('getPaymentHistory',$r->id) }}"
                                        class="btn btn-primary btn-block">Payment</a> --}}

                                        <a href="{{ route('getPaymentHistory',$r->id) }}"
                                            class="btn btn-primary btn-block">Payment</a>

                                    @endcan
                                </td>
                            </tr>

                            @endforeach

                            <!-- More items... -->
                        </tbody>
                    </table>
        </div>



    </div>
</div>




@endsection

@section('ajax')
<script type="text/javascript">
    $(document).ready( function () {

    $('.singlePayment').on('click',function(e){
        e.preventDefault();
        var id = $(this).data('id');

        if(confirm('Are you Confirm! You want to pay the bill!')){
        $('body').append('<div id="loading">Processing.....</div>');
        $.ajax({
            type: 'POST',
            url: '{{ route('singlePayment',) }}',
            data: $(this.form).serialize(),
            dataType:'json',
            success: function (data) {
               if(data.status=='error'){
                   $('#loading').remove();
                   $('body').append(data.message);
               }
               if(data.status=='success'){
                   $('#loading').remove();
                   $('body').append(data.message);
                // console.log(data.message);

                  $('.btn'+id).remove();
               }
            }
        });

    }

    });


} );
</script>
@endsection
