@extends('layout.app')

@section('content')

    <div class="card">
        <div class="card-body">
            <div>
                <h4 class="text-center mb-4">যদি প্যাকেজ এর রেট ০ টাকা হয় তাহলে ৫০০ টাকা হয়ে যাবে।</h4>
            </div>
            <form action="{{ route('newusers.newexport') }}" method="POST">
                @csrf

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Manager</label>
                            <select name="reseller_id" id="reseller" class=" form-control" required>
                                <option value="">Select One</option>
                                <option value="all">All Manager</option>
                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label class=""> POP Name </label>
                        <select name="pop" id="pop" class="form-control" >
                            {{-- <option value="all"> Select One</option> --}}
                        </select>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group float-right mt-2">
                            <button class="btn btn-primary" type="submit"><i class="fas fa-file-excel"></i> Export To
                                Excel</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection


@section('ajax')

    <script type="text/javascript">
        $(function() {

            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#loading').remove();

                    }
                });
            });
        });
    </script>

@endsection
