@extends('layout.app')

@section('content')
    <div class="card  border-gradient">
        <div class="card-body">
            <form action="" id="search">

                <div class="row">
                    <div class="col-md-3 col-sm-3 col-xs-4">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                Manager Name
                            </label>
                            <select name="reseller" id="reseller" class="form-control select2 form-control-sm" required>
                                <option value="all">ALL Manager</option>
                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-4">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                POP Name
                            </label>
                            <select name="pop" id="pop" class="form-control select2 form-control-sm" required>
                                <option value="all"> ALL POP</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-4">
                        <div class="form-group">
                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                Billing Cycle
                            </label>
                            <select name="billing_cycle" id="billing_cycle" class="select2 form-control form-control-sm">
                                <option value="all">ALL</option>
                                @foreach (explode(',', $confday) as $conf)
                                    <option value="{{ $conf }}">{{ $conf }}</option>
                                @endforeach
                            </select>

                        </div>
                    </div>


                </div>
                <div class="form-group float-right">

                    <button @click="search" class="btn btn-primary" type="submit" id="searchBtn">
                        <i class="fa fa-search"></i> Search
                    </button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>
                </div>

            </form>

        </div>
    </div>


    <div class="card">
        <div class="card-body">
            <div id="result">
                {{-- list will show in this box --}}
            </div>
        </div>
    </div>
@endsection




@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
                $('#pop').html('<option value="all">ALL POP</option>');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();

                $('body').prepend('<div id="loading">Loading.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('bulk-expariy-date-extended-search') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        // console.log(result);
                        $('#result').html(result);
                        $('#loading').remove();
                    }
                });
            });


            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="loading">Loading.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#loading').remove();

                    }
                });
            });



        });
    </script>
@endsection


<style>
    .border-gradient {
        border-width: 3px;
        border-style: solid;
        border-image:
            linear-gradient(to bottom,
                red,
                rgba(0, 0, 0, 0)) 1 100%;
    }
</style>
