@extends('layout.app')
@section('content')
    @if (request()->path() == 'admin/newJoin')
        @include('clients.reseller_pop_search')
    @endif

    <div class="card">
        <div class="card-body">

                  <div class="float-right" id="itest" style="{{ (request()->path() == 'admin/newJoin')? 'display:none' : '' }}">
                    @if (isset($print_url) && !empty($print_url))
                        <a style="color: #222" href="{{ route($print_url) }}" target="_blank"><i
                                class="fa fa-print fa-2x"></i></a>
                    @endif
                </div>


            <div class="row mb-1">

                <div class="col-lg-3">
                    {{ $list->onEachSide(1)->links() }}

                </div>
                @if (request()->path() != 'admin/new-join')
                    <div class="col-lg-7">
                        <div class="row counter " style="column-gap:2.5px !important; row-gap:2.5px !important">
                            @php($counter = client_counter())
                            <div class="badge badge-info p-2 col-md-2">Total: {{ $list->total() }}</div>
                            <div class="badge badge-success p-2 col-md-2">Active:
                                {{ $counter->where('clients_status', 'active')->first()->total ?? 0 }}</div>
                            <div class="badge badge-danger p-2 col-md-2">Expired:
                                {{ $counter->where('clients_status', 'expired')->first()->total ?? 0 }}</div>
                            <div class="badge badge-warning p-2 col-md-2">Disable:
                                {{ $counter->where('clients_status', 'disable')->first()->total ?? 0 }}</div>
                            <div class="badge badge-primary p-2 col-md-2">Deactive:
                                {{ $counter->where('clients_status', 'deactive')->first()->total ?? 0 }}</div>
                        </div>
                    </div>
                    <div class="col-lg-2 text-right">
                        <a href="{{ route('clients.create') }}" class="btn  btn-sm"
                            style="background:
                            #FF9F43; color:#FFFFFF;">
                            <i class="fa fa-plus"></i> Add Client</a>
                    </div>
                @endif


            </div>
            @if (request()->path() == 'admin/clients')
                <div class="row mb-1" style="row-gap: 5px; margin-top:20px !important;padding-bottom:10px;">
                    <div class="col-md-1">
                        <input type="text" id="id" placeholder="ID" name="id" class="form-control block">
                    </div>
                    <div class="col-md-2">
                        <input type="text" id="contact" placeholder="Contact" name="contact"
                            class="form-control block">
                    </div>
                    <div class="col-md-2">
                        <input type="text" id="area" placeholder="Area" name="area" class="form-control block">
                    </div>
                    <div class="col-md-1">
                        <input type="text" id="box" placeholder="box" name="box" class="form-control block">
                    </div>
                    <div class="col-md-2">
                        <input type="text" id="customername" placeholder="Name/User Info" name="customername"
                            class="form-control block">
                    </div>
                    <div class="col-md-2">
                        <input type="text" id="customerCode" placeholder="Code" name="customerCode" class="form-control block">
                    </div>
                    <div class="col-md-2">
                        @if (isset($print_url) && !empty($print_url))
                            <div>

                            </div>
                        @else
                            <input type="text" id="customer_search" placeholder="Username" name="customer_search"
                                class="form-control block">
                        @endif


                        {{-- <input type="text" id="customer_search" name="customer_search" class="float-right"> --}}

                    </div>
                </div>
            @endif

            <div id="processing">
                <div>Processing.....</div>
            </div>

            <select id="order-select" class="form-control col-md-2">
                <option value="id_asc">ID (ascending)</option>
                <option value="id_desc">ID (descending)</option>
                <option value="name_asc">Username (ascending)</option>
                <option value="name_desc">Username (descending)</option>
            </select>


            <div id="customer_list_body">

                @include('clients.customer_search')
            </div>

        </div>




        <div class="card-footer">

            {{ $list->onEachSide(1)->links() }}
          
        </div>


    </div>

    <style>
        div#processing {
            display: none;
        }

        .counter div {
            font-size: 15px;
        }

        td {
            /* padding:5px!important; */
        }

        div#processing div {
            background: rgba(0, 0, 0, .5);
            position: fixed;
            width: 100vw;
            height: 100vh;
            color: #fff;
            text-align: center;
            vertical-align: middle;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media print {
            a {
                text-decoration: none !important;
                color: #222 !important;
            }

            th {
                font-size: 10px !important;
                padding: 2px !important;
                text-align: center;
            }

            tr {
                font-size: 10px !important;
                margin: 2px !important;
                padding: 2px !important;
            }

            td {
                font-size: 10px !important;
                margin: 2px !important;
                padding: 2px !important;
            }

            table {
                width: 100%;
            }

            .shadow {
                box-shadow: none;
            }

            tr th:last-child {
                display: none !important;
            }

            tr td:last-child {
                display: none !important;
            }

        }
    </style>


@endsection


@section('ajax')
@include('clients.JsFile.Customer')
@endsection

