@extends('layout.app')

@section('content')

    <div class="card">
        <div class="card-body">
            <form method="post" id="searchForm">
                @csrf
                @method('post')
                <div class="row">

                    @if ($reseller)
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Select Manager</label>
                                <select name="reseller" id="reseller" class="form-control form-control-sm select2">
                                    <option value="">Select One</option>
                                    @foreach ($reseller as $r)
                                        <option value="{{ $r->id }}">{{ $r->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    @endif

                    @if ($poplist)
                        <div class="col-md-4">
                            <label> Select POP </label>
                            <select name="pop" id="pop" class="form-control form-control-sm select2">
                                <option value=""> Select One</option>
                                @foreach ($poplist as $r)
                                    <option value="{{ $r->id }}">{{ $r->popname }}</option>
                                @endforeach
                            </select>
                        </div>
                    @else
                        <div class="col-md-4">
                            <label> Select POP </label>
                            <select name="pop" id="pop" class="form-control form-control-sm select2">
                                <option value=""> Select One</option>
                            </select>
                        </div>
                    @endif
                    <div class="col-md-4">
                        <div class="form-group float-right mt-4">
                            <button class="btn btn-primary" type="submit" id="searchBtn"><i class="fa fa-search"></i>
                                Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>

            </form>
        </div>
    </div>

    <div class="row">
        <div id="result" class="table-responsive" style="">

        </div>
    </div>

    <style>
        div#processing {
            display: none;
        }

        div#processing div {
            background: rgba(0, 0, 0, .5);
            position: fixed;
            width: 100vw;
            height: 100vh;
            color: #fff;
            text-align: center;
            vertical-align: middle;
            display: flex;
            justify-content: center;
            align-items: center;
        }

    </style>


@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
                $('#pop').html('<option value="all">Select One</option>');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $("#loader").show();
                // $('body').append('<div id="processing">processing.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('oflineCustomerResult') }}',
                    data: $('#searchForm').serialize(),
                    success: function(result) {
                        console.log(result);
                        $('#result').html(result);
                        $('#dataTable').DataTable({
                            'destroy': true,
                        });
                        // $('#processing').remove();
                        $("#loader").hide();
                    }
                });
            });


            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="processing">processing.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#processing').remove();
                    }
                });
            });

        });
    </script>
@endsection
