@extends('layout.app')

@section('content')

    <div class="card">
        <div class="card-body">
            <form action="" id="search" class="resellerRechargeLog">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Manager </label>
                            <select name="reseller" id="reseller" class="form-control form-control-sm select2">
                                <option value="">Select One</option>
                                {{-- @if (auth()->user()->hasRole('Admin')) --}}

                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach

                                {{-- @else
                                    <option value="{{ $auth_reseller->id }}">{{ $auth_reseller->name }}</option>
                                @endif --}}
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label> Select POP </label>
                        <select name="pop" id="pop" class="form-control form-control-sm select2">
                            <option value="all"> Select One</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group float-right mt-4">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>

                {{-- <div id="result">

                </div> --}}

            </form>


        </div>
    </div>


    <div class="mt-2 card">
        <div class="card-body">
            <div id="customer_list_body">
                <div id="result" class="table-responsive" style="">
                    @if (true)
                    @else
                        <h4>Total Online: {{ $list->count() }}</h4>
                        <table id="dataTable" class="display table">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col"> User ID </th>
                                    <th scope="col"> Client IP </th>
                                    <th scope="col"> NAS IP </th>
                                    <th scope="col"> MAC Address </th>
                                    <th scope="col"> Reason </th>
                                    <th scope="col"> Last Update </th>
                                    <th scope="col"> Uptime </th>
                                    <th>Date</th>
                                    <th scope="col"></th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">

                                @foreach ($list as $r)
                                    {{-- {{dd($r)}} --}}
                                    <tr>
                                        <td> {{ $r->username }} </td>
                                        <td> {{ $r->framedipaddress }} </td>
                                        <td> {{ $r->nasipaddress }} </td>
                                        <td> {{ $r->callingstationid }} </td>
                                        <td>{{ $r->acctterminatecause }}</td>
                                        <td>{{ $r->acctupdatetime }}</td>
                                        <td> {{ \Carbon\Carbon::parse($r->acctstarttime)->diffForHumans() }} </td>
                                        <td> {{ $r->acctstarttime }} </td>

                                        <td class="px-6 text-center text-sm font-medium">
                                            <a href="{{ route('onlineUserDisconnect') }}?id={{ $r->radacctid }}"
                                                class="btn btn-danger">Disconnect</a>
                                        </td>
                                    </tr>
                                @endforeach

                                <!-- More items... -->
                            </tbody>
                        </table>
                    @endif

                </div>
            </div>
        </div>
        <div class="card-footer">
        </div>
    </div>

    <style>
        div#processing {
            display: none;
        }

        div#processing div {
            background: rgba(0, 0, 0, .5);
            position: fixed;
            width: 100vw;
            height: 100vh;
            color: #fff;
            text-align: center;
            vertical-align: middle;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        @media print {
            a {
                text-decoration: none !important;
                color: #222 !important;
            }

            th {
                font-size: 10px !important;
                padding: 2px !important;
                text-align: center;
            }

            tr {
                font-size: 10px !important;
                margin: 2px !important;
                padding: 2px !important;
            }

            td {
                font-size: 10px !important;
                margin: 2px !important;
                padding: 2px !important;
            }

            table {
                width: 100%;
            }

            .shadow {
                box-shadow: none;
            }

            tr th:last-child {
                display: none !important;
            }

            tr td:last-child {
                display: none !important;
            }

        }
    </style>


@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {

                $("#loader").show();
                $('#result').html('');
                $('#pop').html('<option value="all">Select One</option>');
                $("#loader").hide();
            });

            $('#searchBtn').on('click', function(e) {
                $("#loader").show();
                e.preventDefault();
                // $('body').append('<div id="processing">processing.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('onlineCustomerSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        // console.log(result);
                        $('#result').html(result);
                        $('#processing').remove();
                        $('#dataTable').DataTable({
                            'destroy': true,
                        });
                        $("#loader").hide();

                    }
                });
            });




            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $("#loader").show();

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#processing').remove();
                        $("#loader").hide();
                    }
                });
            });

        });
    </script>
@endsection
