@if (checkAPI())
    <h5>Total Online: {{ $count }}</h5>
    <div class="table-responsive">


        <table id="dataTable" class="table table-borderd table-striped">
            <thead class="custom-table-head">
                <tr>
                    <th scope="col"> User ID </th>
                    <th scope="col"> Client IP </th>
                    <th scope="col"> NAS IP </th>
                    <th scope="col"> MAC Address </th>
                    <th scope="col"> Uptime </th>
                    <th scope="col"></th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach ($allMikrotikAndActiveUsers as $mikrotikAndActiveUsers)
                    @foreach ($mikrotikAndActiveUsers['activeUsers'] as $client)
                        <tr>
                            <td>
                                {{ $client['name'] }}
                            </td>
                            <td>
                                {{ $client['address'] }}
                            </td>

                            <td>
                                {{ $mikrotikAndActiveUsers['nasIp'] }}
                            </td>

                            <td>
                                {{ $client['caller-id'] }}
                            </td>

                            <td>
                                {{ $client['uptime'] }}
                            </td>

                            <td class="px-6 text-center text-sm font-medium">
                                <a href="{{ route('clients.show', $clients[$client['name']]) }}"
                                    class="noprint btn btn-primary btn-xs btn-block mb-1">View live Traffice</a>
                                @can('onlineUserDisconnection')
                                    <a href="{{ route('userDisconnect', $client['name']) }}"
                                        class="btn btn-danger">Disconnect</a>
                                @endcan
                            </td>
                        </tr>
                    @endforeach
                @endforeach





                <!-- More items... -->
            </tbody>
        </table>

        <div class="p-5">
            {{-- {{ $list->links() }} --}}
        </div>
    </div>
@else
    <h5>Total Online: {{ $list->count() }}</h5>
    {{-- @can('discount-online-all')
        @if ($list->count() > 0)
            <a onclick="return confirm('Are you sure you want disconnect ?');" href="{{ route('disconnectAll') }}"
                class="btn btn-danger float-right">Disconnect All</a>
        @endif
    @endcan --}}
    <div class="table-responsive">
        <table id="dataTable" class="display table">
            <thead class="bg-gray-50">
                <tr>
                    <th scope="col"> User ID </th>
                    <th scope="col"> Client IP </th>
                    <th scope="col"> NAS IP </th>
                    <th scope="col"> MAC Address </th>
                    <th scope="col"> Last Update </th>
                    <th scope="col"> Uptime </th>
                    <th>Date</th>
                    <th scope="col">Action</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">


                @foreach ($list as $r)
                    <tr>
                        <td> {{ $r->username }} </td>
                        <td> {{ $r->framedipaddress }} </td>
                        <td> {{ $r->nasipaddress }} </td>
                        <td> {{ $r->callingstationid }} </td>
                        <td> {{ $r->acctupdatetime }}</td>
                        <td> {{ \Carbon\Carbon::parse($r->acctstarttime)->diffForHumans() }} </td>
                        <td> {{ $r->acctstarttime }} </td>

                        <td class="px-6 text-center text-sm font-medium">
                            @if (checkSettings('show-traffice') == 'enable')
                                <a href="{{ route('clients-with-userName', $r->username) }}"
                                    class="noprint btn btn-primary btn-xs btn-block  mb-1">View live Traffice</a>
                            @endif
                            @can('onlineUserDisconnection')
                                <a href="{{ route('onlineUserDisconnect') }}?id={{ $r->radacctid }}"
                                    class="btn btn-danger">Disconnect</a>
                            @endcan


                        </td>
                    </tr>
                @endforeach


                <!-- More items... -->
            </tbody>
        </table>

        <div class="p-5">
            @can('discount-online-all')
                @if ($list->count() > 0)
                    <a onclick="return confirm('Are you sure you want disconnect ?');" href="{{ route('disconnectAll') }}"
                        class="btn btn-danger float-right">Disconnect All</a>
                @endif
            @endcan
            {{-- {{ $list->links() }} --}}
        </div>
    </div>
@endif
