@extends('layout.app')

@section('content')
    @include('clients.reseller_pop_search')


    <div class="mt-2 card">
        <div class="card-body">
            <div id="customer_list_body">
                <div id="result" class="table-responsive">
                    @include('clients.customer_search')
                </div>
            </div>


            <div class="approval">
                <form action="{{ route('approveAllPending') }}" method="post" id="allPendingApproveForm">
                    @csrf
                    @method('post')
                    <input type="hidden" name="client_ids[]" id="client_ids">
                </form>
            </div>

            <div class="approval">
                <form action="{{ route('firstApproveAllPending') }}" method="post" id="firstAllPendingApproveForm">
                    @csrf
                    @method('post')
                    <input type="hidden" name="first_client_ids[]" id="first_client_ids">
                </form>
            </div>

        </div>
        <div class="card-footer">
        </div>
    </div>
@endsection

@section('ajax')
    <script>
        $(function() {
            $('#allSelect').on('click', function() {
                if (this.checked) {
                    $('.new_class_for_client_id_of_pending').each(function() { //loop through each checkbox
                        $(this).prop('checked', true); //check
                    });
                } else {
                    $('.new_class_for_client_id_of_pending').each(function() { //loop through each checkbox
                        $(this).prop('checked', false); //uncheck
                    });
                }
            });
            $('#allApprove').on('click', function(e) {
                e.preventDefault();
                var ids = [];
                $('.new_class_for_client_id_of_pending').each(function() {
                    id = $(this).filter(':checked').val();
                    if (id != null) {
                        ids.push(id);
                    }
                });
                $('#client_ids').val(ids);
                $('#allPendingApproveForm').submit();
            });

            $('#firstAllApprove').on('click', function() {
                var ids = [];
                $('.checkbox').each(function() {
                    id = $(this).filter(':checked').val();
                    if (id != null) {
                        ids.push(id);
                    }
                });
                $('#first_client_ids').val(ids);
                $('#firstAllPendingApproveForm').submit();
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').append('<div id="processing">processing.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('pendingCustomerSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                        $('#processing').remove();
                    }
                });
            });
        });
    </script>
@endsection
