@extends('layout.app')
@section('content')
    <div class="card">

        <div class="card-header d-flex justify-content-between noprint">
            <button class="btn btn-info btn-sm" onclick="window.print()">Print</button>
            <div>

                <form class="form-inline">
                    @csrf
                    <div class="form-group">
                        <label for="month" class="pr-2">Month</label>
                        <select name="month" id="month" class="form-control" required>
                            <option value="">Select Month</option>
                            <option value="{{ today()->format('F') }}">{{ today()->format('F') }}</option>
                            <option value="{{ today()->addMonth()->format('m') }}">{{ today()->addMonth()->format('F') }}
                            </option>

                        </select>
                    </div>
                </form>
            </div>
            </select>
            {{ $list->links() }}

        </div>
        <div class="card-body">

            @foreach ($list as $r)
                <table>
                    <tr>
                        <td style="padding-right:30px;border-right:1px dashed #000;">
                            <img src="{{ asset('storage/company') }}/{{ $company_info->img_url }}" alt="no"
                                height="50px" width="50px">
                            <h3 style="font-weight: bold">{{ $company_info->name ?? '' }}</h3>
                            For Office Use
                            <hr>
                            Invoce No: {{ date('Y') }}{{ $r->invoice_id ?? '' }}<br>
                            CID: {{ $r->id }}<br>
                            Name: {{ $r->clients_name ?? '' }}<br>
                            Username: {{ $r->userid }}<br>
                            Mobile: {{ $r->contact_no ?? '' }}<br>
                            Monthly Bill: {{ $r->billamount ?? '' }}<br>
                            Total: {{ $r->due_amount ?? '' }}<br><br>

                            Signature:

                        </td>
                        <td style="padding-left: 25px">
                            <table>
                                <tr>
                                    <td>
                                        <img src="{{ asset('storage/company') }}/{{ $company_info->img_url }}"
                                            alt="no" height="50px" width="50px">
                                    </td>
                                    <td style="text-align: center;" colspan="2">
                                        <h3 style=" font-weight:bold;">{{ $company_info->name ?? '' }}</h3>
                                    </td>
                                    <td style="text-align: right" colspan="2">
                                        {!! $company_info->address !!}<br>
                                        {{ $company_info->mobile ?? '' }}
                                    </td>

                                </tr>
                                <tr>

                                    <td colspan="3">
                                        To<br>
                                        CID: {{ $r->id }}<br>
                                        Name: {{ $r->clients_name ?? '' }}<br>
                                        Username: {{ $r->userid }}<br>
                                        Mobile: {{ $r->contact_no ?? '' }}<br>
                                        Address: H O: {{ $r->owner_name ?? '' }},
                                        F No: {{ $r->flat_no ?? '' }},
                                        B Name: {{ $r->building_name ?? '' }},
                                        R No: {{ $r->road_no ?? '' }},
                                        Block/Sector: {{ $r->block_sector ?? '' }},
                                        Area : {{ $r->area ?? '' }},
                                        Box : {{ $r->box ?? '' }}.

                                    </td>
                                    <td style="text-align: right">
                                        Customer Copy
                                    </td>

                                </tr>
                                <tr style="background-color: #b8b8b8">
                                    <td style="border: 1px solid #000; padding-left:5px">IP: </td>
                                    <td style="border: 1px solid #000; padding-left:5px">Total Due:
                                        {{ $r->due_amount ?? '' }}</td>
                                    <td style="border: 1px solid #000; padding-left:5px"> Invoice No:
                                        {{ date('Y') }}{{ $r->invoice_id ?? '' }}</td>
                                    <td style="border: 1px solid #000; padding-left:5px">Billing Date:
                                        {{ $r->billdate ?? '' }}</td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #000; padding-left:5px">
                                        SL.
                                    </td>
                                    <td style="border: 1px solid #000; padding-left:5px">
                                        Description
                                    </td>
                                    <td style="border: 1px solid #000; padding-left:5px">
                                        Month
                                    </td>
                                    <td style="border: 1px solid #000; padding-left:5px">Bill Amount</td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #000; padding-left:5px">
                                        1
                                    </td>
                                    <td style="border: 1px solid #000; padding-left:5px">
                                        Monthly Bill
                                    </td>
                                    <td style="border: 1px solid #000; padding-left:5px">
                                        {{ date('F', strtotime($r->billdate ?? '')) }}
                                    </td>
                                    <td style="border: 1px solid #000; padding-left:5px">{{ $r->billamount ?? '' }}</td>
                                </tr>
                                <tr>
                                    <td style="border: 1px solid #000; padding-left:5px">
                                        2
                                    </td>
                                    <td style="border: 1px solid #000; padding-left:5px">
                                        Prevoius Due
                                    </td>
                                    <td style="border: 1px solid #000; padding-left:5px">
                                        --
                                    </td>
                                    <td style="border: 1px solid #000; padding-left:5px">
                                        @if ($r->due_amount > 0)
                                            {{ abs($r->billamount - $r->due_amount) }}
                                        @else
                                            {{ 0 }}
                                        @endif
                                    </td>
                                </tr>
                                <tr>

                                    <td colspan="3"
                                        style="border: 1px solid #000; text-align:center; font-weight:bold; font-size:20px">
                                        Total Due
                                    </td>
                                    <td style="border: 1px solid #000; font-weight:bold; font-size:20px ; padding-left:5px">
                                        {{ $r->due_amount ?? '' }}
                                    </td>
                                </tr>
                            </table>

                        </td>
                    </tr>
                </table><br>
                <hr style="border-top:1px dashed #000;padding-top:20px;">
            @endforeach

        </div>
    </div>
@endsection

@section('ajax')
    <style>
        table {
            width: 100%;
            padding: 2px;
        }

        td {
            padding: 2px;
        }

        @media print {
            .card-header {
                display: none;
            }
            .noprint{
                display: none!important;
            }

            td {
                padding: 2px;
            }

            td {
                font-size: 16px !important;
            }

            .cname {
                font-size: 50px;
            }
        }
    </style>

    <script type="text/javascript">
        $(document).ready(function() {

            console.log('hi');
            $('#month').on('change', function() {
                var selectedValue = $(this).val();

                // Make the AJAX request
                $.ajax({
                    url: '{{ route('setMonthForInvoicePrint') }}',
                    method: 'POST', // or 'GET', depending on your server setup
                    data: {
                        selectedValue: selectedValue
                    },
                    success: function(response) {
                        location.reload();
                    }
                });
            });
        });
    </script>
@endsection
