@can('dashboard-billing-info')
    @can('pop-wise-dashboard-report')

        <section class="card">
            <div class="card-header">
                <h1 class="card-title float-none">Report Pop/Sub Manager wise of Monthly Generated Bill Collection
                    {{ date('M') }}
                    {{ date('Y') }}</h1>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover table-responsive-lg">
                        <thead>
                            <tr>
                                <th scope="col" class="h6 ">Pop/Sub Manager</th>
                                <th scope="col" class="h6">Bill Client</th>
                                <th scope="col" class="h6 text-right">Bill Amount</th>
                                <th scope="col" class="h6">Received Client</th>
                                <th scope="col" class="h6 text-right">Received Amount</th>
                                <th scope="col" class="h6 text-right">Discount Amount</th>
                                <th scope="col" class="h6">Collection(%)</th>
                                <th scope="col" class="h6">Dues Clients</th>
                                <th scope="col" class="h6 text-right">Dues Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $dueClients = 0;
                                $dueAmounts = 0;
                                $clientscount = 0;
                                $totalBill = 0;
                                $totalAdjustment = 0;
                                $totalPaid = 0;
                                $totalDiscount = 0;
                            @endphp

                    @foreach ($popWiseBillReport as $item)
                        @php
                            $totalBill += $item->total_bill;
                            $clientscount += $item->total_row;
                            $dueClients += $item->not_paid;
                            $dueAmounts += $item->total_bill - $item->total_paid;
                            $totalPaid += $item->total_paid;
                            $totalDiscount += $item->total_discount;
                            
                        @endphp
                        <tr>
                            <td>{{ $item->popname }}</td>
                            <td>{{ $item->total_row }}</td>
                            <td class="text-right">
                                <span class="bg-danger py-1 px-3 rounded text-right">
                                    {{ $item->total_bill }}
                                </span>
                            </td>
                            <td>{{ $item->total_row - $item->not_paid }}</td>
                            <td class="text-right">{{ $item->total_paid - $item->total_discount }}</td>
                            <td class="text-right">{{ $item->total_discount }}</td>
                            <td>
                                @if($item->total_bill!=0 && $item->total_paid != 0)
                                {{ round(($item->total_paid * 100) / $item->total_bill,2) }}%
                                @endif
                            </td>
                            <td>{{ $item->not_paid ?? 0}}</td>
                            <td class="text-right">{{ $item->total_bill - $item->total_paid }}</td>
                        </tr>
                    @endforeach

                    
                    <tr class="bg-gray">
                        <td class="h6">Total</td>
                        <td class="h6">{{ $clientscount }}</td>
                        <td class="h6 text-right">{{ $totalBill }}</td>
                        <td class="h6">{{ $clientscount - $dueClients }}</td>
                        <td class="h6 text-right">{{ round($totalPaid) }}</td>
                        <td class="h6 text-right">{{ round($totalPaid) - round($totalDiscount) }}</td>
                        <td class="h6">
                            <span class="text-default">
                                @if ($totalBill != 0)
                                    {{ number_format(($totalPaid * 100) / $totalBill, 2) }} %
                                @else
                                    0%
                                @endif
                            </span>

                                </td>
                                <td class="h6 text-center">
                                    {{ $dueClients }}
                                </td>

                                <td class="h6 text-center">

                                    {{ round($dueAmounts) }}

                                </td>

                    </tr>
                </tbody>
            </table>
        </section>      
        
    @endcan
@endcan



<style>
    .card-title {
        font-size: 32px !important;
        text-align: center !important;
        letter-spacing: 0.10rem;
        font-weight: 500;
    }

    .manager-bg {
        background-color: rgb(221 214 254 / 0.05);
        --tw-text-opacity: 1;
        color: rgb(3 7 18 / var(--tw-text-opacity));
    }

    .table-data {
        background-color: rgb(255 241 242 / 0.5);
        --tw-text-opacity: 1;
        color: rgb(15 23 42 / var(--tw-text-opacity));
    }
</style>
