<nav class="navbar navbar-default banner">
    <div class="container-fluid">
        <!-- Brand and toggle get grouped for better mobile display -->
        <div class="navbar-header">
            <button type="button" class="navbar-toggle collapsed" data-toggle="collapse"
                data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
                <span class="sr-only">Toggle navigation</span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </button>
            <a class="navbar-brand" href="#"><img src="{{ asset('images/others/bar.svg') }}" width="20px"
                    alt="notification icon"></a>
        </div>

        <!-- Collect the nav links, forms, and other content for toggling -->
        <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">

            <form class="navbar-form navbar-right navbar-form-search" role="search">
                <div class="search-form-container hdn" id="search-input-container">
                    <div class="search-input-group">
                        <button type="button" class="btn btn-default" id="hide-search-input-container"><span
                                class="glyphicon glyphicon-option-horizontal" aria-hidden="true"></span></button>
                        <div class="form-group">
                            <input type="text" class="form-control" placeholder="Search for...">
                        </div>
                    </div>

                </div>

                <button type="submit" class="btn btn-default" id="search-button"><span
                        class="glyphicon glyphicon-search" aria-hidden="true"></span></button>
            </form>


            <ul class="nav navbar-nav navbar-right navbar-nav-primary">
                @if (siteinfo()->online_offline_topbar == 'Yes')
                    @cannot('specific_management_services')
                        <li><a href="#">Home</a></li>
                        <li><a href="#">Project</a></li>
                    @endcannot
                @endif

                @can('radius_online_customer_reset')
                    <li><a href="#">Gallery</a></li>
                @endcan

                @if (checkAPI() == false)
                    @can('refresh')
                        <li class="nav-item">
                            <a class="btn border m-1" href="{{ route('refresh_session') }}" >
                                Refresh
                            </a>
                        </li>
                    @endcan
                @endif


                @if (checkSettings('store') == 'enable')
                    @hasanyrole('Reseller Admin|Reseller|Sub Reseller')
                        <a class="btn border m-1" href="{{ route('requisition.create') }}">
                            Requisition
                        </a>
                    @endhasanyrole
                @endif

                @can('customer-monitoring')
                    <a href="{{ route('customerMonitoring') }}" class="btn border m-1" role="menuitem">
                        Customer Monitoring
                    </a>
                @endcan

                @hasrole('Admin|Store Manager')delete online customer
                    <li><a href="#">Publication</a></li>
                @endhasrole


                <li>
                    @if (checkSettings('local-user-first-approve') == 'enable')
                        <a href="#">Events</a>
                    @else
                        <a href="#">News</a>
                    @endif

                </li>

            </ul>
        </div><!-- /.navbar-collapse -->
    </div><!-- /.container-fluid -->
</nav>



<style>
    .banner {
        background: #fff;
        font-family: Lato, sans-serif;
    }

    .navbar-nav-primary {
        text-transform: uppercase;
    }

    .navbar-form-search {
        position: relative;
    }

    .navbar-form-search .form-control {
        width: 250px;
    }

    .navbar-form-search .btn {
        border: 0;
        background: transparent;
        font-size: 18px;
    }

    .navbar-form-search .btn:active,
    .navbar-form-search .btn:hover,
    .navbar-form-search .btn:focus {
        color: #000;
        outline: none;
        box-shadow: none;
    }

    .navbar-form-search .search-form-container {
        text-align: right;
        position: absolute;
        width: 300px;
        overflow: hidden;
        background: #fff;
        right: 60px;
        top: 0;
        z-index: 9;
        transition: all 0.3s ease-in-out;
    }

    .navbar-form-search .search-form-container.hdn {
        width: 0;
    }

    .navbar-form-search .search-form-container .search-input-group {
        width: 300px;
    }
</style>


<script>
    (function($) {

        $('#search-button').on('click', function(e) {
            if ($('#search-input-container').hasClass('hdn')) {
                e.preventDefault();
                $('#search-input-container').removeClass('hdn')
                return false;
            }
        });

        $('#hide-search-input-container').on('click', function(e) {
            e.preventDefault();
            $('#search-input-container').addClass('hdn')
            return false;
        });

    })(jQuery);
</script>
