<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ siteinfo()->name }}</title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="{{ asset('/') }}plugins/fontawesome-free/css/all.min.css">
    <!-- IonIcons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('/') }}adminlte/css/adminlte.min.css">
    <link rel="stylesheet" href="{{ asset('/') }}plugins/daterangepicker/daterangepicker.css">




    <link rel="stylesheet" href="{{ asset('/') }}plugins/daterangepicker/daterangepicker.css">
    <!-- iCheck for checkboxes and radio inputs -->
    <link rel="stylesheet" href="{{ asset('/') }}plugins/icheck-bootstrap/icheck-bootstrap.min.css">
    <!-- Bootstrap Color Picker -->
    <link rel="stylesheet" href="{{ asset('/') }}plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css">
    <!-- Tempusdominus Bootstrap 4 -->
    <link rel="stylesheet"
        href="{{ asset('/') }}plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css">
    <!-- Select2 -->
    <link rel="stylesheet" href="{{ asset('/') }}plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="{{ asset('/') }}plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
    <!-- Bootstrap4 Duallistbox -->
    <link rel="stylesheet" href="{{ asset('/') }}plugins/bootstrap4-duallistbox/bootstrap-duallistbox.min.css">
    <!-- BS Stepper -->
    <link rel="stylesheet" href="{{ asset('/') }}plugins/bs-stepper/css/bs-stepper.min.css">
    <!-- dropzonejs -->
    <link rel="stylesheet" href="{{ asset('/') }}plugins/dropzone/min/dropzone.min.css">

    <link rel="stylesheet" href="{{ asset('/') }}css/toastr.min.css">

    <link rel="stylesheet" href="{{ asset('/') }}css/jquery.dataTables.min.css">
    <link href="{{ asset('css/navbar.css') }}" rel="stylesheet">
    <link href="{{ asset('css/sidebar.css') }}" rel="stylesheet">
    @stack('styles')

    {{-- fontawesome --}}

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"
        integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />


    <style>
        @import url('https://fonts.googleapis.com/css2?family=Nunito+Sans:opsz,wght@6..12,400;6..12,500;6..12,600;6..12,700;6..12,800&display=swap');

        .opacity-50 {
            opacity: .5;
        }

        .content-wrapper {

            font-family: 'Nunito Sans', sans-serif;

        }

        .dataTableLoader {
            display: none;
        }

        table .tableheader th {
            font-size: 14px;
            text-align: center;
            white-space: nowrap;
            font-weight: normal;
        }

        table#dataTable {
            /* min-height: 330px; */
        }

        div.table-responsive {
            min-height: 250px;
        }

        div#result {
            min-height: 250px;
        }

        div#processing {
            display: none;
            z-index: 99999999;
        }

        div#processing div {
            background: rgba(0, 0, 0, .5);
            position: fixed;
            width: 100vw;
            height: 100vh;
            top: 0;
            left: 0;
            color: #fff;
            text-align: center;
            vertical-align: middle;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .invoicewrapper .invoice {
            padding: 25px;
        }

        .invoiceModal {
            display: none;
            position: fixed;
            z-index: 999;
            background: rgba(0, 0, 0, .5);
            width: 100%;
            height: 100vh;
        }

        .portalInvoiceModal {
            display: none;
            position: fixed;
            z-index: 999;
            background: rgba(0, 0, 0, .5);
            width: 100%;
            height: 100vh;
        }

        .portalmodal {
            position: relative;
            height: 98vh;
            overflow-y: scroll;
            margin-right: -20px;
        }

        body {
            font: 90%/1.45em "Helvetica Neue", HelveticaNeue, Helvetica, Arial, sans-serif !important;
            background: #FFF;
        }

        .custom-switch {
            padding-left: 2.25rem;
            transform: scale(2);
            position: absolute;
            margin-left: 32px;
        }

        td.expired,
        td.deactivated {
            background-color: #dc3545 !important;
            color: #fff;
            text-align: center;
            text-transform: capitalize;
        }

        td.disable {
            background-color: #ffc107 !important;
            color: #fff;
            text-align: center;
            text-transform: capitalize;
        }

        td.active {
            background-color: #28a745 !important;
            color: #fff;
            text-align: center;
            text-transform: capitalize;
        }

        table.dataTable.no-footer {
            border-bottom: initial;
        }

        table.dataTable thead.bg-gray-50 {
            background: #6c757d !important;
            color: #fff;
            font-size: 12px;
            font-weight: bold;
        }


        span.select2-selection.select2-selection--single {
            height: 40px;
        }

        .loader {
            background: rgba(255, 255, 255, 1);
            position: fixed;
            width: 100vw;
            height: 100vh;
            z-index: 99999999999;
            padding-top: 40vh;
            overflow: hidden;
        }

        div#loading {
            display: block;
            width: 100vw;
            background: rgba(0, 0, 0, .5);
            height: 100vh;
            position: fixed;
            z-index: 99;
            color: #fff !important;
            text-align: center;
            padding-top: 50vh;
        }

        .main-sidebar {
            height: inherit;
            min-height: 100%;
            position: fixed !important;
            top: 0;
            height: 100vh !important;
            overflow-x: hidden;


        }


        .spinner {
            display: none;
        }

        .topSearchbar {
            max-height: 50vh;
            padding: 5px;
            overflow-y: auto;
            background: #fff;
            position: absolute;
            top: 3px;
            border: 1px solid #ddd;
            box-shadow: 0 0 10px 1px #999;
            max-width: 100vw;
            right: 5px;
            z-index: 999;
            left: 0;
        }

        .customermodal {
            position: relative;
            height: 98vh;
            overflow-y: scroll;
            margin-right: -20px;
        }

        .zoom-in-out-box {
            animation: zoom-in-zoom-out 5s ease infinite;
        }

        td a,
        td span {
            white-space: nowrap;
        }

        #balanceHints {
            position: fixed;
            width: 200px;
            z-index: 99;
            background: skyblue;
            bottom: 10px
        }

        .companyTitleName a {
            word-break: break-word;
            white-space: break-spaces;
            text-align: left;
            font-size: 16px !important;
        }

        @keyframes zoom-in-zoom-out {
            0% {
                transform: scale(1, 1);
            }

            50% {
                transform: scale(1.2, 1.2);
            }

            100% {
                transform: scale(1, 1);
            }
        }



        @media (max-width:1024px) {
            ul.pagination {
                zoom: .8;
            }

            nav {
                margin-top: 70px;
            }

            .topFixed {
                position: fixed;
                width: 100%;
                background: #fff;
                z-index: 99;
                left: 0;
                top: 0;
                border-bottom: 1px solid rgba(255, 193, 7, 0.80);
            }

            .full-mobile {
                width: 100%;
            }

            .navbar {
                display: block;
            }

            .modal-content {
                width: 100% !important;
            }
        }


        /* .content-wrapper {
            margin-left: 265px!important;
        }

        ul.nav.nav-pills.nav-sidebar.flex-column {
            height: calc( 100vh - 100px );
            display: block;
            width: 260px;
            padding: 12px;
            overflow-y: auto;
            position: fixed;
            padding-bottom: 50px;
            overflow-x: hidden;
        }

        aside.main-sidebar.sidebar-dark-primary.elevation-4 {
            position: fixed;
        }

        i.fas.fa-angle-left.right {
            width: 22px;
        } */

        .elevation-2 {
            box-shadow: none !important;
            border-right: 1px solid #d1d5db;
            background: #FFF;
        }

        .sidebar-collapse>div .companyTitleName {
            display: none !important;
        }
    </style>


</head>

@if (\Request::route()->getName() == 'clients.index')

    <body class="hold-transition skin-blue sidebar-collapse sidebar-mini">
    @else

        <body class="hold-transition sidebar-mini">
@endif


<div class="loader text-center" id="loader">
    <p>Data Loading....</p>
    <img src="{{ asset('/loader.gif') }}" alt="">
</div>
<div class="loader text-center" id="processing">
    <p>Processing....</p>
    <img src="{{ asset('/loader.gif') }}" alt="">
</div>


<div class="wrapper">
    @if (Auth::user()->hasRole('Admin'))
    @if (Auth::user()->id != 1)
        @if (config('app.license_check'))
            @if (license_check()['info']['client_type'] != 'Lifetime')
                @if (license_check()['info']['license_check'] && license_check()['total_due'] > 0)
                    <div class="modal fade" id="alertNotification" tabindex="-1" role="dialog"
                        aria-labelledby="alertNotification">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title text-center" id="myModalLabel">Payment Notification</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"
                                        id="extend_close"><span aria-hidden="true">&times;</span></button>
                                </div>
                                <div class="modal-body">

                                    <div class="alert alert-danger">
                                        <h4 class="text-center">নিরবিচ্ছিন্ন সার্ভিস পেতে বিল পরিশোধ করুন। Due Amount:
                                            {{ license_check()['total_due'] }}. Please <a
                                                class="btn btn-sm btn-primary"
                                                href="https://{{ license_check()['pay_url'] }}"
                                                style="text-decoration:none">Pay Now</a></h4>
                                    </div>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal"
                                        id="extend_close_btn">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @endif
        @endif
    @endif
    @endif
    <div class="invoiceModal"></div>
    <div class="portalInvoiceModal"></div>

    @include('layout.nav_lte')
    @include('layout.leftaside_lte')
    @if (siteinfo()->notice_yes_no == 'Yes')
        <div id="newsTicker" style="overflow: hidden">
            <p class="zoom-in-out-box"
                style="
            color: red;
            font-size: 18px;
            text-align: center;
            margin-top: 15px;
            font-weight: bold;">
                {{-- {!! siteinfo()->notice !!} --}}
                @if (Auth::user()->hasRole('Admin'))
                    @if (config('app.license_check'))
                        @if (license_check()['info']['client_type'] != 'Lifetime')
                            @if (license_check()['info']['license_check'] && license_check()['total_due'] > 0)
                                নিরবিচ্ছিন্ন সার্ভিস পেতে বিল পরিশোধ করুন। Due Amount:
                                {{ license_check()['total_due'] }} BDT. Please <a class="btn btn-sm btn-primary"
                                    href="https://{{ license_check()['pay_url'] }}" style="text-decoration:none">Pay
                                    Now</a>
                            @endif
                        @endif
                    @endif
                @endif
            </p>
        </div>
    @endif




    <div class="d-none"><input type="text" id="show_online_offline_in_top_bar"
            value="@if (siteinfo()->online_offline_topbar == 'Yes') Yes @else  No @endif">
    </div>


    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">


        <!-- Content Header (Page header) -->
        <div>
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        @if (\Request::route()->getName() == 'dashboard')
                        @else
                            @if (isset($page_title))
                                {{ $page_title }}
                            @endif
                        @endif

                    </div><!-- /.col -->

                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <input type="hidden" id="inv_exp_date" value="{{ license_check()['exp_date']->exp_date ?? '' }}">
        <input type="hidden" id="inv_extended_exp_date"
            value="{{ license_check()['exp_date']->expire_extend ?? '' }}">
        <!-- Main content -->
        <div class="content">
            <div class="container-fluid">
                @include('layout.alert')
                @if (isset($add_button))
                    <x-Custom.Btn :url="$url" :value="$value" :class="$class"></x-Custom.Btn>
                @endif
                @yield('content')
                <!-- /.row -->
            </div>
            <!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <!-- Control Sidebar -->
    <aside class="control-sidebar control-sidebar-dark elevation-2">


    </aside>
    <!-- /.control-sidebar -->


    <!-- Main Footer -->
    <footer class="main-footer px-5 font-semibold">
        <strong class="tracking-wider">Copyright &copy; {{ date('Y') }} <a href="https://yetfix.com"
                class="tracking-wide">Yetfix
                LTD</a>.</strong>
        All rights reserved.
        <div class="float-right d-none d-sm-inline-block">
            <b>Version</b> 1.0.1
        </div>
    </footer>
</div>


<!-- Modal For Customer Paymnet and all of status e,g - active,deactive -->
@include('paymenthistory.paymentModal')
@include('clients.ModalFile.BillCycleChange')
@include('clients.ModalFile.PackageChange')
@include('clients.ModalFile.AddOtc')
@include('clients.ModalFile.DeactiveDateChange')
@include('clients.ModalFile.PackageChangeWithoutCost')
@include('clients.ModalFile.ChnageExpireDate')

<!-- Modal For Customer Paymnet and all of status e,g - active,deactive end-->


<!-- ./wrapper -->

<!-- REQUIRED SCRIPTS -->

<!-- jQuery -->
<script src="{{ asset('/') }}plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap -->
<script src="{{ asset('/') }}plugins/bootstrap/js/bootstrap.bundle.min.js"></script>


<script src="{{ asset('/') }}plugins/daterangepicker/daterangepicker.js"></script>



<!-- Select2 -->
<script src="{{ asset('/') }}plugins/select2/js/select2.full.min.js"></script>
<!-- Bootstrap4 Duallistbox -->
<script src="{{ asset('/') }}plugins/bootstrap4-duallistbox/jquery.bootstrap-duallistbox.min.js"></script>
<!-- InputMask -->
<script src="{{ asset('/') }}plugins/moment/moment.min.js"></script>
<script src="{{ asset('/') }}plugins/inputmask/jquery.inputmask.min.js"></script>
<!-- date-range-picker -->
<script src="{{ asset('/') }}plugins/daterangepicker/daterangepicker.js"></script>
<!-- bootstrap color picker -->
<script src="{{ asset('/') }}plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="{{ asset('/') }}plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Bootstrap Switch -->
<script src="{{ asset('/') }}plugins/bootstrap-switch/js/bootstrap-switch.min.js"></script>
<!-- BS-Stepper -->
<script src="{{ asset('/') }}plugins/bs-stepper/js/bs-stepper.min.js"></script>
<!-- dropzonejs -->
<script src="{{ asset('/') }}plugins/dropzone/min/dropzone.min.js"></script>

<!-- AdminLTE -->
<script src="{{ asset('/') }}adminlte/js/adminlte.js"></script>



<script src="{{ asset('/') }}js/toastr.min.js"></script>

{!! Toastr::message() !!}

<!-- OPTIONAL SCRIPTS -->
<script src="{{ asset('/') }}plugins/chart.js/Chart.min.js"></script>
<!-- AdminLTE for demo purposes -->
{{-- <script src="{{asset('/')}}adminlte/js/demo.js"></script> --}}
<!-- AdminLTE dashboard demo (This is only for demo purposes) -->
{{-- <script src="{{asset('/')}}adminlte/js/pages/dashboard3.js"></script> --}}

<script src="{{ asset('/') }}js/jquery.dataTables.main.js"></script>




<!-- Js file for customer payment along with status functionality eg activve,deactive -->
@include('clients.JsFile.CustomerAllProperties')
@include('clients.JsFile.AjaxcloseDelete')
@include('clients.JsFile.PackageChangeExceptcost')
{{-- @include('clients.JsFile.Customer') --}}
<!-- Js file for customer payment along with status functionality eg activve,deactive end-->

<script>
    /*license check for client payment to yefix start*/
$(window).on('load', function() {
        var exp_date = $('#inv_exp_date').val();
        var extend_exp_date = $('#inv_extended_exp_date').val();
        cd = (new Date()).toISOString().split('T')[0];
        if(exp_date < cd){
            if(extend_exp_date < cd){
                $('#alertNotification').modal({backdrop: 'static', keyboard: false}, 'show');
                $('#extend_close').hide();
                $('#extend_close_btn').hide();
            }else{
                // $('#alertNotification').modal('show');
                $('#alertNotification').modal({backdrop: 'static', keyboard: false}, 'show');
            }
        }
    });
/*license check for client payment to yefix end*/
</script>
@yield('ajax')

@stack('js')

</body>

</html>
