@extends('layout.app')
@section('content')
    <form action="{{ route('mikrotiks.update', $nas->id) }}" method="POST">
        @method('put')
        @csrf
        <div class="card">
            <div class="card-body">
                <div class="form-group">
                    <label for="shortname" class="block text-sm font-medium text-gray-700">
                        Mikrotik Name*
                    </label>
                    <input type="text" name="shortname" id="shortname" value="{{ $nas->shortname }}" class="form-control " required
                        placeholder="Mikrotik Name" autocomplete="off">
                    @error('shortname')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group">
                    <label for="nasname" class="block text-sm font-medium text-gray-700">
                        Mikrotik IP*
                    </label>
                    <input type="text" name="nasname" id="nasname" class="form-control" placeholder="Mikrotik IP" required
                        value="{{ $nas->nasname }}" autocomplete="off">
                    @error('nasname')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                @if (!checkAPI())
                    <div class="form-group">
                        <label for="secret" class="block text-sm font-medium text-gray-700">
                            Secret*
                        </label>
                        <input type="text" name="secret" id="secret" class="form-control"
                            placeholder="Mikrotik Radius Secret" value="{{ $nas->secret }}" autocomplete="off" required>
                        @error('secret')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                @endif
                <div class="form-group">
                    <label for="secret" class="block text-sm font-medium text-gray-700">
                        Mikrotik User Name
                    </label>
                    <input type="text" name="mickrotik_user_name" id="mickrotik_user_name" class="form-control"
                        value="{{ $nas->mikrotick_user }}" placeholder="Mikrotik user name" autocomplete="off">
                    @error('secret')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror

                </div>

                <div class="form-group">
                    <label for="secret" class="block text-sm font-medium text-gray-700">
                        Mikrotik Password
                    </label>
                    <input type="text" name="mickrotik_user_password" id="mickrotik_user_password" class="form-control"
                        value="{{ $nas->mikrotick_user_password }}" placeholder="Mikrotik user password" autocomplete="off">
                    @error('secret')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror

                </div>

                <div class="form-group">
                    <label for="secret" class="block text-sm font-medium text-gray-700">
                        Mikrotik Port
                    </label>
                    <input type="text" name="mickrotik_port" id="mickrotik_port" class="form-control"
                        value="{{ $nas->mikrotick_port }}" placeholder="Mikrotik Port" autocomplete="off">
                    @error('secret')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror

                </div>
                <div class="form-group">
                    <label for="about" class="block text-sm font-medium text-gray-700">
                        Description*
                    </label>

                    <textarea id="about" name="description" rows="3" class="form-control" placeholder="Description" required>{{ $nas->description }}</textarea>

                    @error('description')
                        <div class="alert alert-danger mt-1">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                @if (checkSettings('static_ip_manage') == 'enable')
                    <div class="form-group">
                        <h6>Static Ip Block</h6> <button id="addIpBlock" class="btn btn-info" style="float: right">Add</button>

                        <div class="row">
                            <div class="col-md-12">

                                <table id="ip_block" class="table table-bordered">
                                    <thead class="thead-dark">
                                        <th>Port</th>
                                        <th>Ip Block</th>
                                        <th></th>
                                    </thead>
                                    <tbody>
                                        @php
                                            $ip_block = json_decode($nas->ip_block);
                                        @endphp
                                        @if ($ip_block != null)
                                            @foreach ($ip_block as $block)
                                                @if ($block)
                                                    <tr>
                                                        <td style="width: 30%"><input type="text" name="port[]"
                                                                class="form-control " value="{{ $block->port }}" required>
                                                        </td>
                                                        <td style="width: 65%"><input type="text" name="ip_block[]"
                                                                class="form-control " value="{{ $block->ip_block }}"
                                                                required></td>
                                                        <td style="width: 5%"><button class="btn btn-danger btn-sm remove"
                                                                type="button"><i class="fa fa-minus"></i></button>
                                                        </td>
                                                    </tr>
                                                @else
                                                    <tr>
                                                        <td style="width: 30%"><input type="text" name="port[]"
                                                                class="form-control " required></td>
                                                        <td style="width: 65%"><input type="text" name="ip_block[]"
                                                                class="form-control " required></td>
                                                        <td style="width: 5%"></td>
                                                    </tr>
                                                @endif
                                            @endforeach
                                        @endif

                                    </tbody>
                                </table>
                            </div>
                        </div>

                    </div>
                @endif
                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">
                        Update
                    </button>
                </div>

            </div>
        </div>


    </form>
    @if (auth()->user()->id == 1 && checkAPI())
        {{ $mkServices }}
    @endif
@endsection

@push('js')
    <script>
        $(document).ready(function() {
            $('#addIpBlock').click(function() {
                var html = '<tr>';
                html += '<td><input type="text" name="port[]" class="form-control " required></td>';
                html += '<td><input type="text" name="ip_block[]" class="form-control " required></td>';
                html +=
                    '<td><button type="button" name="remove" class="btn btn-danger btn-sm remove"><i class="fa fa-minus"></i></button></td></tr>';
                $('#ip_block').append(html);
            });

            $(document).on('click', '.remove', function() {
                $(this).closest('tr').remove();
            });

        });
    </script>
@endpush
