@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">



            <form action="{{ route('packages.update', $list->id) }}" method="POST">
                @method('PUT')
                @csrf
                <div class="row">
                    <div class="form-group col-md-6">
                        <label for="package_name" class="block text-sm font-medium text-gray-700">
                            Package Name*
                        </label>
                        <input type="text" name="package_name" id="package_name" value="{{ $list->package_name }}"
                            class="form-control " placeholder="Package Name" autocomplete="off" required>
                        @error('package_name')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="form-group col-md-6">
                        <label for="package_rate" class="block text-sm font-medium text-gray-700">
                            Package Rate
                        </label>
                        <input type="text" name="package_rate" id="package_rate"
                            class="focus:ring-indigo-500 focus:border-indigo-500 form-control" placeholder="Package Rate"
                            value="{{ $list->package_rate }}" autocomplete="off" required>

                        @error('package_rate')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-6">
                        <label for="pool_name" class="block text-sm font-medium text-gray-700">
                            @if (checkAPI())
                                Profile Name
                            @else
                                Pool Name
                            @endif
                        </label>

                        @if (checkAPI())
                            <input type="text" name="profile_name" id="profile_name"
                                class="focus:ring-indigo-500 focus:border-indigo-500 form-control"
                                placeholder="Profile Name" value="{{ $list->profile_name }}" autocomplete="off">
                            @error('profile_name')
                                <div class="alert alert-danger">
                                    {{ $message }}
                                </div>
                            @enderror
                        @else
                            <input type="text" name="pool_name" id="pool_name"
                                class="focus:ring-indigo-500 focus:border-indigo-500 form-control" placeholder="Pool Name"
                                value="{{ $list->pool_name }}" autocomplete="off" required>
                            @error('pool_name')
                                <div class="text-red-500 mt-2 text-sm">
                                    {{ $message }}
                                </div>
                            @enderror
                        @endif
                    </div>
                    @if (checkSettings('package_limite_quantity') == 'enable')
                        <div class="form-group col-md-6">
                            <label for="package_rate" class="block text-sm font-medium text-gray-700">
                                Limite Quanity
                            </label>
                            <input step="0.01" type="number" name="limite_quantity" id="limite_quanity"
                                class="focus:ring-indigo-500 focus:border-indigo-500 form-control"
                                placeholder="Limite Quanity In GB" min="0" value="{{ $list->limite_quantity }}"
                                autocomplete="off" required>
                            @error('limite_quantity')
                                <div class="alert alert-danger">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    @endif

                    <div class="form-group col-md-6">
                        <label for="package_rate" class="block text-sm font-medium text-gray-700">
                            Package Bandwidth for BTRC Report
                        </label>
                        <input type="number" name="package_bandwidth" id="package_bandwidth" min="0"
                            class="focus:ring-indigo-500 focus:border-indigo-500 form-control"
                            value="{{ $list->package_bandwidth }}" autocomplete="off" required>
                        @error('package_bandwidth')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-6">
                        <label for="package_rate" class="block text-sm font-medium text-gray-700">
                            Package Price for BTRC Report
                        </label>
                        <input type="number" name="btrc_package_price" id="btrc_package_price"
                            class="focus:ring-indigo-500 focus:border-indigo-500 form-control"
                            placeholder="Package Price for BTRC Report" value="{{ $list->btrc_package_price }}"
                            autocomplete="off">
                        @error('btrc_package_price')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    @if (checkSettings('static_ip_manage') == 'enable')
                        <div class="form-group col-md-6">
                            <span class="text-green"><strong>Note :</strong> Upload Speed & Download Speed এ যা দিবেন তা ৮ দিয়ে ভাগ হবে EX: (1MB / 8 = 128kb)</span>
                            <div class="row">
                                <div class="form-group col-md-6">
                                    <label for="package_rate" class="block text-sm font-medium text-gray-700">
                                        Package Upload Speed
                                    </label>
                                    <input step="0.01" type="text" name="speed_up" id="speed_up"
                                        class="focus:ring-indigo-500 focus:border-indigo-500 form-control"
                                        placeholder="Package Upload Speed" value="{{ $list->speed_up }}" autocomplete="off"
                                        required>
                                    @error('speed_up')
                                        <div class="alert alert-danger">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                <div class="form-group col-md-6">
                                    <label for="package_rate" class="block text-sm font-medium text-gray-700">
                                        Package Download Speed
                                    </label>
                                    <input step="0.01" type="text" name="speed_down" id="speed_down"
                                        class="focus:ring-indigo-500 focus:border-indigo-500 form-control"
                                        placeholder="Package Download Speed" value="{{ $list->speed_down }}"
                                        autocomplete="off" required>
                                    @error('speed_down')
                                        <div class="alert alert-danger">
                                            {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    @endif



                    @if (checkSettings('package-commission') == 'enable')
                        <div class="form-group col-md-6">
                            <label for="pool_name" class="block text-sm font-medium text-gray-700">
                                Commission
                            </label>

                            <input type="number" name="commission" id="commission"
                                class="focus:ring-indigo-500 focus:border-indigo-500 form-control"
                                placeholder="commission" value="{{ $list->commission }}" autocomplete="off">
                            @error('commission')
                                <div class="text-red-500 mt-2 text-sm">
                                    {{ $message }}
                                </div>
                            @enderror

                        </div>
                    @endif
                </div>
                <div class="form-group">
                    <a class="float-left btn btn-default" href="{{ url()->previous() }}">Back</a>
                    <button type="submit" class="btn btn-primary float-right">
                        Update
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
