<button class="btn btn-primary mb-2" onclick="export2csv()">Download csv</button>
<div class="col-md-12">
    <div class=" float-right d-flex amount-container" style="text-align:center; gap:3px !important; ">
        <p class="p-1 " style="border:2px solid #fed7aa; ">Total Row {{ $list->count() ?? 0 }} </p>
        <p class="p-1 " style="border:2px solid #fed7aa; ">Total Amount {{ $list->sum('paid_amount') }} TK</p>
        <p class="p-1 " style="border:2px solid #fed7aa; ">Total Discount: {{ $list->sum('discount_amount') }}</p>
    </div>
</div>
<div id="paymenthistory" class="mt-10">
    <div class="table-responsive">
        <table class="table table-bordered " id="tableDownload">
            <tr>
                <th>#id</th>
                <th>Date</th>
                <th>Type</th>
                <th>C Name</th>
                <th>username</th>
                @if (getBillingType() == 'day_to_day')
                    <th>Expire Date</th>
                @endif
                <th>Reseller</th>
                <th>POP</th>
                <th>MR ID</th>
                <th>Entry BY</th>
                <th>Col By</th>
                <th>Package</th>
                <th style="max-width: 150px">Description</th>
                <th>Amount</th>


                @if ($hideColumn == false)
                    <th>Discount</th>
                    {{-- <th>Due</th> --}}
                @elseif ($hideColumn == true)
                @endif
            </tr>

            @php($totalDue = 0 )
            @foreach ($list as $p)
                    <tr>
                        <td>{{ $p->id }}</td>
                        <td class="text-center">{{ date('d-M-Y h:i:s A', strtotime($p->created_at)) }}</td>
                        <td>{{ $p->income->head->name ?? '' }}</td>
                        <td>{{ $p->clientsinfo->clients_name ?? '' }}</td>
                        <td>{{ $p->clients->userid ?? '' }}</td>
                        @if (getBillingType() == 'day_to_day')  <td> {{$p->clients->expire_date}}</td> @endif
                        <td>{{ $p->clients->pop->reseller->name ?? '' }}</td>
                        <td>{{ $p->clients->pop->popname ?? '' }}</td>
                        <td>{{ $p->money_receipt_number }}</td>
                        <td>{{ $p->user->name ?? '' }}</td>
                        <td class="text-center">{{ $p->employee->name ?? '' }}</td>
                        <td> {{ $p->clients->packages->package_name ?? '' }}</td>
                        <td style="max-width: 150px">{{$p->description ?? ""}}</td>
                        <td class="text-right"> {{ $p->paid_amount }}</td>
                        @if ($hideColumn == false)
                            <td class="text-right"> {{ $p->discount_amount }}</td>
                            {{-- <td class="text-right">
                                {{ $p->clients->customerAccount->dueAmount > 0 ? $p->clients->customerAccount->dueAmount : 0 }}
                                @php($totalDue+= ($p->clients->customerAccount->dueAmount > 0 ? $p->clients->customerAccount->dueAmount : 0) )

                            </td> --}}
                        @elseif ($hideColumn == true)
                        @endif
                    </tr>

            @endforeach

            <tr class="hidden">
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                <td></td>
                @if (getBillingType() == 'day_to_day')  <td> </td> @endif
                <td></td>
                <td class="text-right"><b>Total:</b> </td>
                <td class="text-right"><b>{{ $list->sum('paid_amount') }} TK</b></td>
                @if ($hideColumn == false)
                    <td class="text-right"><b>{{ $list->sum('discount_amount') }} TK</b></td>
                    {{-- <td class="text-right"><b>{{ $totalDue }} TK</b></td> --}}
                @elseif ($hideColumn == true)
                @endif
            </tr>
        </table>
    </div>
</div>
<script>

    function export2csv() {
      let data = "";
      const tableData = [];
      const rows = document.querySelectorAll("table#tableDownload tr");
      for (const row of rows) {
        const rowData = [];
        for (const [index, column] of row.querySelectorAll("th, td").entries()) {
          // To retain the commas in the "Description" column, we can enclose those fields in quotation marks.
          if ((index + 1) % 3 === 0) {
            rowData.push('"' + column.innerText + '"');
          } else {
            rowData.push(column.innerText);
          }
        }
        tableData.push(rowData.join(","));
      }
      data += tableData.join("\n");
      const a = document.createElement("a");
      a.href = URL.createObjectURL(new Blob([data], { type: "text/csv" }));
      a.setAttribute("download", "data.csv");
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
    }

    </script>

<style>
    .amount-container{
        flex-direction: column;
    }
    @media (min-width:640px){
        .amount-container{
            flex-direction: row;
        }
    }
</style>
