@extends('layout.app')

@section('content')

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-12">
                <a href="{{ route('payroll.salaryGenerate') }}" class="btn btn-success mb-4" style="float: right">All Employee Salary Generate</a>
            </div>
        </div>
        <div class="table-responsive">
            <table id="dataTable" class="display table">
                <thead class="bg-gray-50">
                    <tr>
                        <th>Employee Id</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Number</th>
                        <th>Salary</th>
                        <th>Joining Date</th>
                        <th>Salary Generate</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($employees as $employee)
                        <tr>
                            <td>{{ $employee->employee_id }}</td>
                            <td>{{ $employee->name }}</td>
                            <td>{{ $employee->email }}</td>
                            <td>{{ $employee->mobile_personal }}</td>
                            <td>{{ $employee->current_salary }}</td>
                            <td>{{ $employee->join_date }}</td>
                            <td>
                                @if ($employee->salary_generate == 1)
                                    {{ 'yes' }}
                                @else
                                    {{ 'no' }}
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('payrollEmployee.show', $employee->id) }}" class="btn btn-info btn-sm">View</a>
                                <a href="{{ route('payrollEmployee.edit', $employee->id) }}" class="btn btn-warning btn-sm">Edit</a>
                            </td>
                        </tr>
                    @endforeach

                    <!-- More items... -->
                </tbody>
            </table>
        </div>

    </div>
</div>

@endsection
