@extends('layout.app')


@section('content')
    <div class="row">
        <div class="col-sm-4">
            <div class="card">
                <div class="card-body">
                    <p class="p-2">Pop Name: {{ $pop->popname }}</p>
                    <p class="p-2" style="font-size:30px;font-weight:bold">Current Balance:
                        {{ $pop->balance[0]['amount'] ?? 0}}</p>
                    <hr>

                    <div class="form-group">
                        <label for="amount">Amount</label>
                        <input type="number" class="form-control" id="amount" name="amount" placeholder="Enter Amount">
                    </div>
                    @if (checkSettings('bkash-pop-recharge') == 'enable')
                        <button class="btn btn-danger" id="bkash">Bkash</button>
                    @endif
                    @if (checkSettings('upay-pop-recharge') == 'enable')
                        <button class="btn btn-danger" id="upay">Upay</button>
                    @endif
                    @if (checkSettings('nagad-pop-recharge') == 'enable')
                        <button class="btn btn-danger" id="nagad">Nagad</button>
                    @endif

                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="card">
                <div class="card-body">
                    <p class="p-2">Pop Recharge History </p>

                    <div class="form-group">
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="bg-blue-50">
                                    <tr>

                                                <th scope="
                                            col"
                                            class="">
                                                    Date
                                                </th>

                                                <th scope="
                                            col"
                                            class="">
                                                    Amount
                                                </th>

                                                <th scope="
                                            col"
                                            class="">
                                                    After Recharge Balance
                                                </th>

                                                <th scope="
                                            col"
                                            class="">
                                                    Remarks
                                                </th>
                                                <th scope="
                                            col"
                                            class="">
                                                    Recharge By
                                                </th>
                                                <th scope="
                                            col"
                                            class="">

                                                </th>
                                    </tr>
                                </thead>
                                <tbody class="
                                            bg-white divide-y divide-gray-200">

                                            @foreach ($popList as $r)

                                    <tr>

                                        <td class="px-6 py-4 whitespace-nowrap">
                                            {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}
                                        </td>



                                        <td class="px-6 py-4 whitespace-nowrap text-right">
                                            {{ $r->amount }}
                                        </td>


                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 text-right">
                                            {{ $r->after_recharge_balance }}
                                        </td>

                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                            {{ $r->remarks }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                            {{ $r->user->name ?? '' }}
                                        </td>


                                    </tr>

                                    @endforeach
                                    </tbody>
                            </table>
                        </div>





                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@push('js')
    <script>
        $(document).ready(function() {

            $('#upay').on('click', function() {
                payment('upay');
            });

            $('#bkash').on('click', function() {
                payment('bkash');
            });

            $('#nagad').on('click', function() {
                payment('nagad');
            });

            function payment(payment_method) {
                // $('#processing').show();
                $.ajax({
                    url: "{{ route('onlinePopRechargeExecute') }}",
                    type: "POST",
                    data: {
                        amount: $('#amount').val(),
                        payment_method: payment_method,
                        pop_id: {{ $pop->id }},
                    },
                    success: function(data) {
                        $('#processing').hide();
                        console.log(data);

                        if (payment_method == 'upay') {
                            if (data.status == 'error') {
                                toastr.error(data.message);
                            } else if (data.message == "Merchant Payment Init Success") {
                                window.location.href = data.data.gateway_url;
                            }
                        } else if (payment_method == 'bkash') {
                            if (data.status == 'error') {
                                toastr.error(data.message);
                            } else if (data.statusMessage == "Successful") {
                                window.location.href = data.bkashURL;
                            }
                        } else if (payment_method == 'nagad') {
                            if (data.status == 'error') {
                                toastr.error(data.message);
                            } else if (data.status == "success") {
                                window.location.href = data.message;
                            }
                        }


                    }
                });
            }
        });
    </script>
@endpush
