@extends('layout.app')


@section('content')
    <div class="card">

        <div class="card-body">
            <form action="{{ route('pop.update', $list->id) }}" method="POST">
                @method('PUT')
                @csrf

                <div class="row" style="@cannot('pop_edit')display:none @endcannot">

                    <div class="form-group col-md-4">
                        <label for="popname" class="block text-sm font-medium text-gray-700">
                            POP Name*
                        </label>

                        <input type="text" name="popname" id="popname" value="{{ $list->popname }}" class="form-control"
                            placeholder="Pop/Zone Name" autocomplete="off" autofocus required>
                        @error('popname')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="reseller_id" class="block text-sm font-medium text-gray-700">
                            Manager Name*
                        </label>

                        <select class="select2 form-control" name="reseller_id" id="reseller_id" required>
                            <option value="">Select Reseller</option>
                            @foreach ($reseller as $r)
                                <option data-reseller_type="{{ $r->reseller_type }}" value="{{ $r->id }}"
                                    @if ($r->id === $list->reseller_id) selected @endif>{{ $r->name }}
                                </option>
                            @endforeach
                        </select>

                        @error('reseller_id')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="pop_location" class="block text-sm font-medium text-gray-700">
                            POP Location*
                        </label>
                        <input type="text" name="pop_location" id="pop_location" class="form-control"
                            placeholder="pop_location" value="{{ $list->pop_location }}" autocomplete="off" required>
                        @error('pop_location')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="pop_contact" class="block text-sm font-medium text-gray-700">
                            POP Contact*
                        </label>
                        <input type="text" name="pop_contact" id="pop_contact" class="form-control"
                            placeholder="pop_contact" value="{{ $list->pop_contact }}" autocomplete="off" required>

                        @error('pop_contact')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="nas_id" class="block text-sm font-medium text-gray-700">
                            Mikrotik IP*
                        </label>

                        <select name="nas_id" id="nas_id" class="select2 form-control" required>
                            @foreach ($naslist as $l)
                                <option value="{{ $l->id }}" @if ($l->id === $list->nas_id) selected @endif>
                                    {{ $l->nasname }}
                                </option>
                            @endforeach
                        </select>


                        @error('nas_id')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="form-group d-none">
                        <label for="server_authentication" class="block text-sm font-medium text-gray-700">
                            Server Authentication
                        </label>
                        <select name="server_authentication" id="server_authentication" class="form-control">
                            <option value="yes" @if ($list->server_authentication === 'yes') selected @endif>YES</option>
                            <option value="no" @if ($list->server_authentication === 'no') selected @endif>No</option>
                        </select>

                        @error('server_authentication')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>

                    <div class="form-group col-md-4">
                        <label for="longitude" class="block text-sm font-medium text-gray-700">
                            Longitude*
                        </label>

                        <input type="text" name="longitude" id="longitude" class="form-control" placeholder="longitude"
                            value="{{ $list->longitude }}" autocomplete="off" required>

                        @error('longitude')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="latitude" class="block text-sm font-medium text-gray-700">
                            Latitude*
                        </label>

                        <input type="text" name="latitude" id="latitude" class="form-control" placeholder="Latitude"
                            value="{{ $list->latitude }}" autocomplete="off" required>

                        @error('latitude')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="form-group col-md-4 d-none">
                        <label for="billable" class="block text-sm font-medium text-gray-700">
                            Billable
                        </label>
                        <select name="billable" id="billable" class="select2 form-control">
                            <option value="yes" @if ($list->billable === 'yes') selected @endif>YES</option>
                            <option value="no" @if ($list->billable === 'no') selected @endif>No</option>
                        </select>

                        @error('billable')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="form-group col-md-4">
                        <label for="subreseller" class="block text-sm font-medium text-gray-700">
                            Sub Manager
                        </label>
                        <select name="subreseller" id="subreseller" class="form-control select2">
                            <option value="no" @if ($list->subreseller === 'no') selected @endif>No</option>
                            <option value="yes" @if ($list->subreseller === 'yes') selected @endif>Yes</option>

                        </select>

                        @error('subreseller')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    @if ($list->reseller->reseller_type == 'own')
                        <div class="form-group col-md-4">
                            <label for="subreseller" class="block text-sm font-medium text-gray-700">
                                Sms Send to User
                            </label>
                            <select name="sms_send" id="sms_send" class="form-control select2">
                                <option value="no" @if ($list->sms_send === 'no') selected @endif>No</option>
                                <option value="yes" @if ($list->sms_send === 'yes') selected @endif>Yes</option>

                            </select>

                            @error('subreseller')
                                <div class="text-red-500 mt-2 text-sm">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    @endif


                    <div class="form-group col-md-4">
                        <label for="bill_generate" class="block text-sm font-medium text-gray-700">
                            Customer Bill Generate
                        </label>

                        <select name="bill_generate" id="bill_generate" class="form-control" disabled>
                            <option value="no" @if ($list->bill_generate === 'no') selected @endif>No</option>
                            <option value="yes" @if ($list->bill_generate === 'yes') selected @endif>Yes</option>
                        </select>
                        @if ($list->reseller)
                            <input type="hidden" id="bill_generate_value" name="bill_generate_value"
                                value="{{ $list->reseller->reseller_type == 'own' ? 'yes' : 'no' }}">
                        @else
                            <input type="hidden" id="bill_generate_value" name="bill_generate_value" value="yes">
                        @endif
                        @error('bill_generate_value')
                            <div class="text-red-500 mt-2 text-sm alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>
                    <div class="form-group d-none">
                        <label for="package_change_pricing" class="block text-sm font-medium text-gray-700">
                            Package Change Pricing
                        </label>
                        <select name="package_change_pricing" id="package_change_pricing" class="form-control select2">
                            <option value="full_month" @if ($list->package_change_pricing === 'full_month') selected @endif>Full Month
                            </option>
                            <option value="day_by_day" @if ($list->package_change_pricing === 'day_by_day') selected @endif>Day By Day
                            </option>

                        </select>

                        @error('package_change_pricing')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>


                </div>
                @if (checkSettings('pop-online-recharge') == 'enable')
                        <hr class="d-block">
                        <div class="row" style="@cannot('pop-accounts-edit')display: none; @endcannot">


                            <div class="col-md-4">
                                <label for="payment_charges">Gateway Charges%</label>

                                <table class="table">
                                    <tr>
                                        <td>Bkash</td>
                                        <td>
                                            <input type="number" step="any" name="bkash_charges" id="bkash_charges"
                                                class="form-control" placeholder="Bkash Charges"
                                                value="{{ $payment->bkash_charges ?? 0 }}" autocomplete="off">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Nagad</td>
                                        <td>
                                            <input type="number" step="any" name="nagad_charges" id="nagad_charges"
                                                class="form-control" placeholder="Nagad Charges"
                                                value="{{ $payment->nagad_charges ?? 0 }}" autocomplete="off">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Upay</td>
                                        <td>
                                            <input type="number" step="any" name="upay_charges" id="upay_charges"
                                                class="form-control" placeholder="Upay Charges"
                                                value="{{ $payment->upay_charges ?? 0 }}" autocomplete="off">
                                        </td>
                                    </tr>
                                </table>
                            </div>

                            <div class="col-md-4">
                                <label for="enable_online_recharge">Enable Online Recharge</label>
                                <select name="enable_online_recharge" id="enable_online_recharge" class="form-control">
                                    <option value="">Select Option</option>
                                    <option value="1" @if ($list->enable_online_recharge == '1') selected @endif>Yes</option>
                                    <option value="0" @if ($list->enable_online_recharge == '0') selected @endif>No</option>
                                </select>
                            </div>
                        </div>

                @endif

                <div class="form-group">
                    <a class="btn btn-default float-left" href="{{ url()->previous() }}">Back</a>
                    <button type="submit" class="btn btn-primary float-right">
                        Update
                    </button>
                </div>


            </form>
        </div>
    </div>
@endsection

@section('ajax')
    <script>
        $(function() {

            $('#reseller_id').on('change', function() {
                let reseller = $('#reseller_id').find(':selected').data('reseller_type');
                console.log(reseller);
                $('#bill_generate').attr('disabled');
                $('#bill_generate').val([]);
                if (reseller === 'own') {
                    $('#bill_generate').val('yes');
                    $('#bill_generate_value').val('yes');

                } else {
                    $('#bill_generate').val('no');
                    $('#bill_generate_value').val('no');
                }
            });

        });
    </script>
@endsection
