@extends('layout.app')


@section('content')


    <div class="card">
        <div class="card-body">
            <div class="col-md-12">
                <div class="badge badge-info float-right m-1" style="text-align: ">Total Row: {{ $dueOtc->count() }}</div>
            </div>

            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col"
                                class="text-center">
                                ID
                            </th>
                            <th scope="col"
                                class="text-center">
                                Clients Name
                            </th>

                            <th scope="col"
                                class="text-center">
                                Area
                            </th>
                            <th scope="col"
                                class="text-center">
                                Contact No
                            </th>

                            <th scope="col"
                                class="text-center">
                                OTC
                            </th>

                            <th scope="col"
                                class="text-center">
                                Due OTC
                            </th>


                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">

                        @php $total = 0; @endphp

                        @foreach ($dueOtc as $r)

                            <tr>
                                <td class="text-center">
                                    {{ $r->id }}
                                </td>
                                <td class="text-center">
                                    {{ $r->clients_name }}
                                </td>

                                <td class="text-center">
                                    {{ $r->area }}
                                </td>

                                <td class="text-center">
                                    {{ $r->contact_no }}
                                </td>


                                <td class="text-center">



                                    {{ $r->otc }}
                                </td>

                                <td class="text-center">

                                    @php $total += $r->otc_due @endphp
                                    {{ $r->otc_due }}
                                </td>

                            </tr>

                        @endforeach

                        <tr>
                            <td colspan="5" class="text-right">Total: </td>
                            <td class="text-right">{{ number_format($total, 2, '.', '') }}</td>

                        </tr>

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="flex flex-col mt-5">
        <div class=" bg-white p-6 rounded-lg">

            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="py-2 align-middle inline-block min-w-full sm:px-6 lg:px-8">
                    <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">



                    </div>
                </div>
            </div>
        </div>
    </div>




@endsection
