@extends('layout.app')


@section('content')

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
            <table id="dataTable" class="table table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Requisition No.</th>
                        <th>Status</th>
                        <th>Branch</th>
                        <th>Create Date</th>
                        <th>Requisition For</th>
                        <th>Submitted By</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($list as $r)

                        <tr>
                            <td class="text-center">
                                {{ $r->id }}
                            </td>
                            <td class="text-center">
                                {{ $r->requisition_number }}
                            </td>
                            <td class="text-center">
                                {{ $r->status }}
                            </td>
                            <td class="text-center">
                                {{ $r->branch->name ?? '' }}
                            </td>
                            <td class="text-center">
                                {{ date('d-M-Y H:i:s A', strtotime($r->created_at)) }}
                            </td>
                            <td>{{$r->employee->name}}</td>
                            <td>{{$r->user->name}}</td>
                            <td>
                                @can('requisition_show')
                                    <a href="{{ route('requisition.show', $r->id) }}">
                                        <button class="btn btn-primary "> Show</button>
                                    </a>
                                @endcan
                                @can('requisition_approve')
                                    <a href="{{ route('requisition.approve', $r->id) }}">
                                        <button class="btn btn-success "> Approve</button>
                                    </a>
                                @endcan
                            </td>
                        </tr>

                    @endforeach
                </tbody>
            </table>
            </div>
        </div>
        <div class="card-footer">
            {{ $list->links() }}
        </div>
    </div>



@endsection
