@extends('layout.app')


@section('content')

    <div class="card card-default">
        <div class="card-body">

            <form action="{{ route('resellers.store') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="form-group col-md-4">
                        <label for="name" class="block text-sm font-medium text-gray-700">
                            Manager Name*
                        </label>
                        <input type="text" name="name" id="name" value="{{ old('name') }}" class="form-control" required
                            placeholder="Manager Name" autocomplete="off">
                        @error('name')<div class="alert alert-danger">{{ $message }}</div>@enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="name" class="block text-sm font-medium text-gray-700">
                            Manager Type*
                        </label>
                        <select name="reseller_type" id="reseller_type" class="select2 form-control" required>
                            <option value="">Select Type</option>
                            <option value="other">Other</option>
                            <option value="own">Own</option>
                        </select>
                        @error('reseller_type')<div class="alert alert-danger">{{ $message }}</div>@enderror
                    </div>

                     <div class="form-group col-md-4">
                        <label for="contact" class="block text-sm font-medium text-gray-700">
                            Contact*
                        </label>

                        <input type="text" name="contact" id="contact" class="form-control" placeholder="Contact" required
                            value="{{ old('contact') }}" autocomplete="off">
                        @error('contact')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-6">
                        <label for="address" class="block text-sm font-medium text-gray-700">
                            Address*
                        </label>

                        <input type="text" name="address" id="address" class="form-control" placeholder="Address" required
                            value="{{ old('address') }}" autocomplete="off">

                        @error('address')<div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group col-md-6">
                        <label for="remark" class="block text-sm font-medium text-gray-700">
                            Remark
                        </label>
                        <div class=" flex rounded-md shadow-sm">

                            <input type="text" name="remark" id="remark" class="form-control" placeholder="remark"
                                value="{{ old('remark') }}" autocomplete="off">
                        </div>
                        @error('remark')
                            <div class="alert alert-dangers">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group d-none">
                        <label for="billable" class="block text-sm font-medium text-gray-700">
                            Billable
                        </label>
                        <div class="mt-1 flex rounded-md shadow-sm">

                            <select name="billable" id="billable">
                                <option value="yes">YES</option>
                                <option value="no">No</option>
                            </select>
                        </div>
                        @error('billable')
                            <div class="text-red-500 mt-2 text-sm">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>

                <hr>
                @if(checkSettings('reseller-online-recharge') == 'enable')
                    <div class="form-group col-md-4">
                        <label for="payment_charges">Gateway Charges In %</label>

                        <table class="table table-responsive table-condensed">
                            <tr>
                                <td>Bkash</td>
                                <td>
                                    <input type="number" step="any" name="bkash_charges" id="bkash_charges" class="form-control"
                                        placeholder="Bkash Charges" value="{{ old('bkash_charges') }}" autocomplete="off">
                                </td>
                            </tr>
                            <tr>
                                <td>Nagad</td>
                                <td>
                                    <input type="number" step="any" name="nagad_charges" id="nagad_charges" class="form-control"
                                        placeholder="Nagad Charges" value="{{ old('nagad_charges') }}" autocomplete="off">
                                </td>
                            </tr>
                            <tr>
                                <td>Upay</td>
                                <td>
                                    <input type="number" step="any" name="upay_charges" id="upay_charges" class="form-control"
                                        placeholder="Upay Charges" value="{{ old('upay_charges') }}" autocomplete="off">
                                </td>
                            </tr>
                        </table>
                    </div>
                @endif

                {{-- <div class="col-sm-6">
                    <label for="">Package List</label>
                    @foreach ($packages as $package)
                        <br>
                        <label for="package{{ $package->id }}">
                            <input type="checkbox" id="package{{ $package->id }}" name="package[]"
                                value="{{ $package->id }}"> {{ $package->package_name }}
                        </label>
                    @endforeach
                </div> --}}
                <div class="col-sm-12">


                    <div class="form-group float-right">
                        <button class="btn btn-primary" type="submit"><i class="fa fa-save"></i> Save</button>
                        <button class="btn btn-info" type="reset" id="reset">Reset</button>
                    </div>

                </div>


            </form>


        </div>


    </div>






@endsection
