@extends('layout.app')




@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="card">
                <!-- /.card-header -->
                <div class="card-body">
                    @can('reseller-recharge')
                        <button type="button" class="poprecharge btn btn-primary float-right" data-toggle="modal"
                            data-target="#reseller-recharge">
                            Manager Recharge
                        </button>
                    @endcan
                </div>


                <div class="card-body">



                    <div class="table-responsive">
                        <table id="dataTable" class="display table">
                            <thead class="bg-gray-50">
                                <tr>

                                    <th scope="col">
                                        ID
                                    </th>
                                    <th scope="col">
                                        Manager Name
                                    </th>
                                    <th>

                                    </th>
                                    @canany(['reseller_type', 'specific_management_services'])
                                        <th scope="col">
                                            Reseller Type
                                        </th>
                                    @endcan


                                    <th scope="col">
                                        Address
                                    </th>
                                    <th scope="col">
                                        Contact No
                                    </th>



                                    <th scope="col">
                                        Balance
                                    </th>
                                    @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                        <th scope="col">
                                            Total Due
                                        </th>
                                    @endif

                                    @hasrole('Admin')
                                        <th scope="col">
                                            Remark
                                        </th>
                                    @endhasrole

                                    <th scope="col">

                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">

                                @foreach ($resellers as $r)
                                    {{-- @dd($resellers) --}}
                                    <tr>
                                        <td class="whitespace-nowrap">
                                            {{ $r->id }}
                                        </td>
                                        <td class="whitespace-nowrap">
                                            {{ $r->name }}
                                        </td>
                                        <td>


                                            @cannot('specific_management_services')
                                                @if (checkSettings('reseller-online-recharge') == 'enable')
                                                    <a href="{{ route('onlineManagerRecharge', $r->id) }}"
                                                        class="btn btn-danger">Online Recharge</a>
                                                @endif
                                            @endcannot

                                        </td>
                                        @canany(['reseller_type', 'specific_management_services'])
                                            <td class="whitespace-nowrap">
                                                {{ $r->reseller_type }}
                                            </td>
                                        @endcan

                                        <td class="whitespace-nowrap text-sm text-gray-500">
                                            {{ $r->address }}
                                        </td>

                                        <td class="whitespace-nowrap">
                                            {{ $r->contact }}
                                        </td>

                                        <td class="whitespace-nowrap text-sm text-gray-500">

                                            {{ $r->balance[0]['amount'] ?? 0 }}

                                        </td>

                                        @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                            <td class="whitespace-nowrap text-sm text-gray-500">

                                                @foreach ($due as $d)
                                                    @if ($d->reseller_id == $r->id)
                                                        {{ $d->tamount - $d->tpaid }}
                                                    @endif
                                                @endforeach


                                                {{-- {{ $r->paid->amount }} --}}



                                            </td>
                                        @endif

                                        @hasallroles('Admin')
                                            <td class="whitespace-nowrap text-sm text-gray-500">
                                                {{ $r->remark ?? '' }}
                                            </td>
                                        @endhasallroles


                                        <td class="whitespace-nowrap text-right text-sm font-medium">
                                            <div class="dropdown">
                                                <button class="btn btn-primary dropdown-toggle" type="button"
                                                    id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                                    aria-expanded="false">
                                                    Action
                                                </button>
                                                <div class="btn-primary dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                    @can('view-commission')
                                                        <a class="dropdown-item"
                                                            href="{{ route('view-reseller-commission', $r->id) }}">View
                                                            Commission History</a>
                                                    @endcan
                                                    @can('reseller-recharge')
                                                        <a class="dropdown-item"
                                                            href="{{ route('reseller.recharge', $r->id) }}">Recharge</a>
                                                    @endcan
                                                    @canany(['package-permission', 'specific_management_services'])
                                                        <a class="dropdown-item"
                                                            href="{{ route('reseller.permission', $r->id) }}">Package
                                                            Permission</a>
                                                    @endcan
                                                    @if (Auth()->user()->can('reseller_edit') ||
                                                            Auth()->user()->can('manager-accounts-edit'))
                                                        <a class="dropdown-item"
                                                            href="{{ route('resellers.edit', $r->id) }}">Edit</a>
                                                    @endif
                                                    @can('view-reseller-history')
                                                        <a class="dropdown-item"
                                                            href="{{ route('editLog-history', ['id' => $r->id, 'type' => 'Manager']) }}">History</a>
                                                    @endcan
                                                    @can('reseller-sms-getway')
                                                        @if ($r->reseller_type == 'other')
                                                            <a class="dropdown-item"
                                                                href="{{ route('reseller-sms-gateway', $r->id) }}">Sms
                                                                Gateway</a>
                                                        @endif
                                                    @endcan
                                                </div>
                                            </div>


                                        </td>
                                    </tr>
                                @endforeach

                                <!-- More items... -->
                            </tbody>
                        </table>
                    </div>


                </div>


            </div>


            <!-- /.card-body -->
            <div class="card-footer clearfix">
                {{ $resellers->links() }}
            </div>
        </div>
    </div>
    </div>

    <div class="modal fade" id="reseller-recharge">
        <div class="modal-dialog">
            <form action="{{ route('resellerRecharge.store') }}" method="POST" class="recharge-form">
                @csrf
                @method('post')
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="text-center">Reseller Recharge</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center" id="modalAlert"></div>

                        <div class="row">

                            <div class="col-md-4">Recharge To</div>
                            <div class="col-md-8 mb-2">
                                <select class="form-control select2" name="reseller_id" id="">
                                    <option value="">Select Reseller</option>
                                    @foreach ($resellers as $r)
                                        <option value="{{ $r->id }}">{{ $r->name }}</option>
                                    @endforeach
                                </select>
                            </div>



                            <div class="col-md-4">Recharge Amount</div>
                            <div class="col-md-8 mb-2">
                                <input type="number" name="amount" class="form-control">
                            </div>

                            @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                <div class="col-md-4">Paid Amount</div>
                                <div class="col-md-8 mb-2">
                                    <input type="number" name="paid_amount" class="form-control">
                                </div>
                            @endif

                            <div class="col-md-4">Remark</div>
                            <div class="col-md-8 mb-2">
                                <input type="text" name="remark" id="remark" class="form-control">
                            </div>


                        </div>


                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button class="btn btn-primary recharge-submit" type="submit" id="modalSave">Recharge</button>
                    </div>

                </div>
                <!-- /.modal-content -->
            </form>
        </div>
        <!-- /.modal-dialog -->
    </div>
@endsection

@unlessrole('Reseller')
    @section('ajax')
        <script>
            $(function() {

                $('.recharge-form').on('submit', function() {
                    $('.recharge-submit').attr('disabled', 'true');
                });

                var modalopen = "{{ session('modalopen') }}";

                if (modalopen == "true") {
                    $('.poprecharge').trigger('click');
                }

            });
        </script>
    @endsection
@endunlessrole
