@extends('layout.app')


@section('content')
    <div class="card">

        <div class="card-body">
            <form action="{{ route('reseller.permissionUpdate', $reseller->id) }}" method="POST" id="package_assign_from">
                @method('PUT')
                @csrf

                <input type="hidden" name="reseller_id" value="{{ $reseller->id }}">



                <h2 class="font-bold text-center bg-gray-100 border-gray-100 text-3xl">Manager Name :
                    {{ $reseller->name }}</h2>

                <table class="table mt-5" id="custom_data_table">
                    <thead>

                        <tr class="bg-blue-300 text-center">
                            <th></th>
                            {{-- <th class="text-left "><label for="select_all"><input type="checkbox" id="select_all"> Select All</label></th> --}}
                            <th>ID</th>
                            <th>Package Name</th>
                            <th>Package Rate</th>
                            <th>Pool Name</th>
                        </tr>
                    </thead>
                    <tbody>
                        @can('specific_management_services')
                            @foreach ($packages as $p)
                                @if (in_array($p->id, explode(',', $reseller->package_list)) == true)
                                    <tr>

                                        <td>


                                            <input class="checkbox" id="package_{{ $p->id }}" name="package_id[]"
                                                type="checkbox" value="{{ $p->id }}"
                                                @if (in_array($p->id, explode(',', $reseller->package_list)) == true) checked @endif>

                                        </td>
                                        <td>{{ $p->id }} </td>
                                        <td>{{ $p->package_name }} </td>
                                        <td class="text-center">{{ $p->package_rate }} </td>
                                        <td class="text-center">{{ $p->pool_name }} </td>

                                    </tr>
                                @endif
                            @endforeach
                        @else
                            @foreach ($packages as $p)
                                <tr>

                                    <td>


                                        <input class="checkbox" id="package_{{ $p->id }}" name="package_id[]"
                                            type="checkbox" value="{{ $p->id }}"
                                            @if (in_array($p->id, explode(',', $reseller->package_list)) == true) checked @endif>

                                    </td>
                                    <td>{{ $p->id }} </td>
                                    <td>{{ $p->package_name }} </td>
                                    <td class="text-center">{{ $p->package_rate }} </td>
                                    <td class="text-center">{{ $p->pool_name }} </td>

                                </tr>
                            @endforeach
                        @endcan
                    </tbody>
                </table>

                

                @cannot('specific_management_services')
                    <div class="flex justify-between mt-5 bg-gray-200 p-2">
                        <a href="{{ route('resellers.index') }}" class="btn btn-default float-left"><i
                                class="fa fa-arrow-left"></i> Back</a>
                        {{-- <a href="{{ route('resellers.index') }}"
                        class="rounded bg-gray-900 text-center px-5 py-2 text-white"><i class="fa fa-arrow-left"></i> Back</a> --}}
                        <input type="submit" class="btn btn-primary float-right" id="assign_package_btn"
                            value="Assign Package">
                    </div>
                @endcannot



                <div class="p-5 text-right">
                </div>

            </form>
        </div>
    </div>
@endsection

@section('ajax')
    <script>
        $(function() {
            $('#select_all').on('click', function() {

                if (this.checked) {
                    $('.checkbox').each(function() { //loop through each checkbox
                        $(this).prop('checked', true); //check
                    });
                } else {
                    $('.checkbox').each(function() { //loop through each checkbox
                        $(this).prop('checked', false); //uncheck
                    });
                }

            });



            $('#custom_data_table').DataTable({
                responsive: true,
                "bProcessing": true,
                "iDisplayLength": 100000,
                'order': [
                    [0, "desc"]
                ]
            });

            var l = $('#custom_data_table_filter').find('input');
            l.keyup(function() {
                var value = $(this).val();
                if (value.length > 0) {
                    $('#select_all').prop('checked', false);
                }

            });

            $('#assign_package_btn').click(function(e) {
                e.preventDefault();
                $('#processing').show();

                $('#custom_data_table_filter').find('input').val('');
                $('#custom_data_table').DataTable().search('').draw();
                $('#package_assign_from').submit();
            });
        });
    </script>
@endsection
