@extends('layout.app')


@section('content')
    <div class="row">
        <div class="col-sm-4">
            <div class="card">
                <div class="card-body">
                    <p class="p-2">Manager Name: {{ $reseller->name }}</p>
                    <p class="p-2" style="font-size:30px;font-weight:bold">Current Balance:
                        {{ $reseller->balance[0]['amount'] ?? 0 }}</p>
                    <hr>

                    <div class="form-group">
                        <label for="amount">Amount</label>
                        <input type="number" class="form-control" id="amount" name="amount" placeholder="Enter Amount">
                    </div>

                    @if (checkSettings('bkash-reseller-recharge') == 'enable')
                        <button class="btn btn-danger" id="bkash">Bkash</button>
                    @endif
                    @if (checkSettings('upay-reseller-recharge') == 'enable')
                        <button class="btn btn-danger" id="upay">Upay</button>
                    @endif
                    @if (checkSettings('nagad-reseller-recharge') == 'enable')
                        <button class="btn btn-danger" id="nagad">Nagad</button>
                    @endif

                </div>
            </div>
        </div>
        <div class="col-sm-8">
            <div class="card">
                <div class="card-body">
                    <p class="p-2">Manager Recharge History </p>

                    <div class="form-group">
                        <div class="table-responsive">
                            <table class="table table-borderd table-striped">
                                <thead class="bg-blue-50">
                                    <tr>

                                        <th>
                                            Date
                                        </th>

                                        <th class="text-right">
                                            Recharge Amount
                                        </th>

                                        <th class="text-right">
                                            After Recharge Balance
                                        </th>
                                        @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                            <th class="text-right">Paid Amount</th>
                                        @endif

                                        <th>
                                            Remarks
                                        </th>
                                        <th>
                                            Recharge By
                                        </th>
                                        <th>

                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="
                                        bg-white divide-y divide-gray-200">
                                    @foreach ($rechargeList as $r)
                                        <tr>

                                            <td>
                                                {{ date('d-M-Y h:i:sa', strtotime($r->created_at)) }}
                                            </td>



                                            <td class="text-right">
                                                {{ $r->amount }}
                                            </td>


                                            <td class="text-right">
                                                {{ $r->after_recharge_balance }}
                                            </td>
                                            @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                                <td class="text-right">{{ $r->paid_amount }}</td>
                                            @endif

                                            <td>
                                                {{ $r->remarks }}
                                            </td>
                                            <td>
                                                {{ $r->user->name ?? '' }}
                                            </td>


                                        </tr>
                                    @endforeach

                                    <tr class="bg-info">
                                        <td class="text-right">Total Recharge: </td>
                                        <td class="text-right">{{ $rechargeList->sum('amount') }}</td>
                                        @if (checkSettings('reseller-recharge-paid-option') == 'enable')
                                            <td class="text-right">Total Paid: </td>
                                            <td class="text-right">{{ $rechargeList->sum('paid_amount') }}</td>
                                        @endif
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>





                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection

@push('js')
    <script>
        $(document).ready(function() {

            $('#upay').on('click', function() {
                payment('upay');
            });

            $('#bkash').on('click', function() {
                payment('bkash');
            }); 
            $('#nagad').on('click', function() {
                payment('nagad');
            });

            function payment(payment_method) {
                // $('#processing').show();
                $.ajax({
                    url: "{{ route('onlineManagerRechargeExecute') }}",
                    type: "POST",
                    data: {
                        amount: $('#amount').val(),
                        payment_method: payment_method,
                        reseller_id: {{ $reseller->id }},
                    },
                    success: function(data) {
                        $('#processing').hide();
                        console.log(data);

                        if (payment_method == 'upay') {
                            if (data.status == 'error') {
                                toastr.error(data.message);
                            } else if (data.message == "Merchant Payment Init Success") {
                                window.location.href = data.data.gateway_url;
                            }
                        } else if (payment_method == 'bkash') {
                            if (data.status == 'error') {
                                toastr.error(data.message);
                            } else if (data.statusMessage == "Successful") {
                                window.location.href = data.bkashURL;
                            }
                        } else if (payment_method == 'nagad') {
                            if (data.status == 'error') {
                                toastr.error(data.message);
                            } else if (data.status == "success") {
                                window.location.href = data.message;
                            }
                        }


                    }
                });
            }
        });
    </script>
@endpush
