@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('resellers.update', $reseller->id) }}" method="POST">
                @method('PUT')
                @csrf
                <div class="row" style="@cannot('reseller_edit')display:none @endcannot">
                    <div class="form-group col-md-4">


                        <label for="name">
                            Manager Name*
                        </label>
                        <input type="text" name="name" id="name" value="{{ $reseller->name }}" class="form-control" required
                            placeholder="Manager Name" autocomplete="off">

                        @error('name')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="reseller_type" class="block text-sm font-medium text-gray-700">
                            Manager Type*
                        </label>
                        <select name="reseller_type" id="reseller_type" class="select2 form-control" required>
                            <option value="">Select Type</option>
                            <option value="other" {{ $reseller->reseller_type == 'other' ? 'selected' : '' }}>
                                Other</option>
                            <option value="own" {{ $reseller->reseller_type == 'own' ? 'selected' : '' }}>
                                Own</option>

                        </select>
                    </div>

                    <div class="form-group col-md-4">

                        <label for="contact" class="block text-sm font-medium text-gray-700">
                            *
                        </label>


                        <input type="text" name="contact" id="contact" class="form-control" placeholder="Contact"
                            value="{{ $reseller->contact }}" autocomplete="off" required>

                        @error('contact')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="address">
                            Address*
                        </label>

                        <input type="text" name="address" id="address" class="form-control" placeholder="Address"
                            value="{{ $reseller->address }}" autocomplete="off" required>
                        @error('address')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="remark">
                            Remark
                        </label>
                        <input type="text" name="remark" id="remark" class="form-control" placeholder="remark"
                            value="{{ $reseller->remark }}" autocomplete="off">

                        @error('remark')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>

                    <div class="d-none col-md-4">
                        <div class="col-span-3 sm:col-span-2">
                            <label for="billable" class="block text-sm font-medium text-gray-700">
                                Billable
                            </label>
                            <div class="mt-1 flex rounded-md shadow-sm">

                                <select name="billable" id="billable">
                                    <option value="yes" @if ($reseller->billable === 'yes') selected @endif>YES</option>
                                    <option value="no" @if ($reseller->billable === 'no') selected @endif>No</option>
                                </select>
                            </div>
                            @error('billable')
                                <div class="alert alert-danger">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>




                </div>

                @if (checkSettings('reseller-online-recharge') == 'enable')

                        <hr class="d-block">
                        <div class="form-group col-md-4" style="@cannot('manager-accounts-edit')display: none @endcannot">
                            <label for="payment_charges">Gateway Charges%</label>

                            <table class="table">
                                <tr>
                                    <td>Bkash</td>
                                    <td>
                                        <input type="number" step="any" name="bkash_charges" id="bkash_charges"
                                            class="form-control" placeholder="Bkash Charges" value="{{ $payment->bkash_charges ?? 0 }}"
                                            autocomplete="off">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Nagad</td>
                                    <td>
                                        <input type="number" step="any" name="nagad_charges" id="nagad_charges"
                                            class="form-control" placeholder="Nagad Charges" value="{{ $payment->nagad_charges ?? 0 }}"
                                            autocomplete="off">
                                    </td>
                                </tr>
                                <tr>
                                    <td>Upay</td>
                                    <td>
                                        <input type="number" step="any" name="upay_charges" id="upay_charges"
                                            class="form-control" placeholder="Upay Charges" value="{{ $payment->upay_charges ?? 0 }}"
                                            autocomplete="off">
                                    </td>
                                </tr>
                            </table>
                        </div>
                @endif

                <div class="form-group">
                    <button class="btn btn-primary float-right" type="submit"> Update</button>
                </div>



            </form>

        </div>
    </div>
@endsection
