{{-- @dd($smsLog) --}}
@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">

            <form action="" id="search">
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                {{-- <input type="date" name="from_date" value="{{ $start->format('m/d/y') }}" class="form-control "> --}}
                                <input type="text" name="from_date" value=""
                                    class="form-control form-control-sm datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                {{-- <input type="date" name="to_date" value="{{ $end->format('m/d/y') }}" class="form-control form-control-sm"> --}}
                                <input type="text" name="to_date" value=""
                                    class="form-control form-control-sm datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="type">
                                Type
                            </label>
                            <div class="input-group date" id="type">
                                <select name="type" id="type" class="form-control form-control-sm">
                                    <option value="">Select One</option>
                                    <option value="">All</option>
                                    @foreach ($types as $type)
                                        <option value="{{ $type }}">{{ $type }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="contact">
                                Contact No
                            </label>
                            <div class="input-group date" id="contact">
                                <input type="text" name="contact" id="contact" value=""
                                    class="form-control form-control-sm " placeholder="Phone No" autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-2">

                        <div class="form-group float-right mt-4">
                            <button @click="search" class="btn btn-primary btn-sm" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>

                            <a href="{{ route('smsLog') }}" class="btn btn-info btn-sm">Reset</a>
                        </div>
                    </div>
                </div>
            </form>


            <div class="table-responsive" id="result">
                <div class="float-left">
                    {{ $smsLog->links() }}
                </div>
                <table id="" class="display table table-bordered table-striped table-sm">
                    <thead class="bg-gray">
                        <tr>
                            <th scope="col">ID</th>
                            <th scope="col">Contact</th>
                            <th scope="col" style="max-width: 300px" >Message</th>
                            <th scope="col" >Type</th>
                            <th scope="col" style="max-width: 200px">Delivery Message</th>
                            {{-- <th scope="col">Status</th> --}}
                            <th scope="col">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($smsLog as $item)
                        {{-- {{dd($item)}} --}}
                            <tr>
                                <td>{{ $item->id }}</td>
                                <td>{{ $item->contact }}</td>
                                <td style="max-width: 300px">{{ $item->message }}</td>
                                <td>{{ $item->type }}</td>

                                <td style="max-width: 200px">{!! checkSmsStatus($item->delivery_message) !!}</td>
                                {{-- <td>{{ $item->status }}</td> --}}
                                <td>{{ $item->created_at }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $smsLog->links() }}
            </div>
        </div>
        <div class="card-footer">

        </div>
    </div>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTable').DataTable();
        });

        $(document).ready(function() {
            $('#reset').click(function() {
                $('#result').html('');
            });
            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('smsLogSearchResult') }}',
                    data: $('#search').serialize(),
                    // alert(result);
                    success: function(result) {
                        console.log(result);
                        $('#result').html(result);

                        $('#processing').remove();
                        $('#dataTable').DataTable({
                            'destroy': true,
                        });
                    }
                });
            });

        });
    </script>
@endsection
