@extends('layout.app')
@section('content')
    <div class="card" id="vue_app">
        <div class="card-body">
            <form action="{{ route('sub-packages.store') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="form-group col-md-4">
                        <label for="reseller_id" class="block text-sm font-medium text-gray-700">
                            Manager Name <span class=" text-danger">(require)</span>
                        </label>
                        <select @change="fetch_package" v-model="reseller_id" name="reseller_id" id="reseller_id"
                            class="form-control" required>
                            <option value="">Select Manager</option>
                            @foreach ($resellers as $reseller)
                                <option value="{{ $reseller->id }}">{{ $reseller->name }}</option>
                            @endforeach
                        </select>

                        @error('reseller_id')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-4">
                        <label for="package_id" class="block text-sm font-medium text-gray-700">
                            Package Name <span class=" text-danger">(require)</span>
                        </label>
                        <select name="package_id" id="package_id" class="form-control" required>
                            <option value="">Select Package</option>
                            <option :value="row.id" v-for="row in packages" v-html="row.package_name"></option>
                        </select>

                        @error('package_id')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="name" class="block text-sm font-medium text-gray-700">
                            Name <span class=" text-danger">(require)</span>
                        </label>
                        <input type="text" name="name" id="name" class="form-control" placeholder="Name"
                            value="{{ old('name') }}" autocomplete="off" required>
                        @error('name')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="rate" class="block text-sm font-medium text-gray-700">
                            Rate <span class=" text-danger">(require)</span>
                        </label>
                        <input type="number" name="rate" id="rate" class="form-control" placeholder="Rate"
                            value="{{ old('rate') }}" autocomplete="off" required>

                        @error('rate')
                            <div class="alert alert-danger">
                                {{ $message }}
                            </div>
                        @enderror

                    </div>

                    @if (checkSettings('sub-package-commission') == 'enable')
                        <div class="form-group col-md-4">
                            <label for="rate" class="block text-sm font-medium text-gray-700">
                                Commission
                            </label>
                            <input type="number" name="commission" id="commission" class="form-control"
                                placeholder="commission" value="{{ old('commission') ?? 0 }}" autocomplete="off">

                            @error('commission')
                                <div class="alert alert-danger">
                                    {{ $message }}
                                </div>
                            @enderror

                        </div>
                    @endif
                </div>
                <div class="form-group float-right">
                    <button class="btn btn-primary" type="submit"><i class="fa fa-save"></i> Save</button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>

                </div>


            </form>
        </div>
    </div>
@endsection

@push('js')
    <script src="{{ asset('vue-js/vue/dist/vue.js') }}"></script>
    <script src="{{ asset('vue-js/axios/dist/axios.min.js') }}"></script>
    <script src="{{ asset('vue-js/bootstrap-select/dist/js/bootstrap-select.min.js') }}"></script>
    <script src="{{ URL::asset('assets/libs/bootstrap-datepicker/bootstrap-datepicker.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            var vue = new Vue({
                el: '#vue_app',
                data: {
                    config: {

                        get_reseller_wise_package_url: "{{ url('admin/fetch-package-by-reseller-id') }}",
                    },
                    reseller_id: '',
                    package_id: '',

                    packages: [],

                },
                methods: {


                    fetch_package() {
                        var vm = this;
                        var slug = vm.reseller_id;
                        vm.packages = '';
                        if (slug) {
                            axios.get(this.config.get_reseller_wise_package_url + '/' + slug).then(function(
                                response) {
                                vm.packages = response.data.Packages;
                                console.log(vm.packages);
                            }).catch(function(error) {
                                toastr.error('Something went to wrong', {
                                    closeButton: true,
                                    progressBar: true,
                                });
                                return false;
                            });
                        }
                    }
                },
                updated() {
                    $('.bSelect').selectpicker('refresh');
                }
            });

            $('.bSelect').selectpicker({
                liveSearch: true,
                size: 5
            });
            $('.datepicker').datepicker({
                format: 'dd-mm-yyyy'
            });

        });
    </script>
@endpush
