@extends('layout.app')

@section('content')
    <div class="flex flex-col mt-5">
        <div class=" bg-white p-6 rounded-lg">

            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table id="dataTable" class="table table-bordered">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col">
                                        ID
                                    </th>
                                    <th scope="col">
                                        Package Name
                                    </th>
                                    {{-- @if (in_array('show-sub-package-rate', $permissions))
                                        <th scope="col">
                                            Package Rate
                                        </th>
                                    @endif --}}

                                    @canany(['show-sub-package-rate', 'specific_management_services'])

                                        <th scope="col">
                                            Package Rate
                                        </th>
                                    @endcan

                                    @if (in_array('show-mother-package', $permissions))
                                        <th scope="col">
                                            Manager Name
                                        </th>
                                    @endif
                                    @if (in_array('show-mother-package', $permissions))
                                        <th scope="col">
                                            Mother Package
                                        </th>
                                    @endif

                                    @if (in_array('show-motherpackage-rate', $permissions))
                                        <th scope="col">
                                            Mother Package Rate
                                        </th>
                                    @endif
                                    @if (in_array('sub-pack-commission', $permissions))
                                        <th scope="col">
                                            Commission
                                        </th>
                                    @endif
                                    <th scope="col">

                                    </th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">

                                @foreach ($sub_packages as $r)
                                    <tr>
                                        <td class="whitespace-nowrap">
                                            {{ $r->id }}
                                        </td>
                                        <td class="whitespace-nowrap">
                                            {{ $r->name }}
                                        </td>

                                        {{-- @if (in_array('show-sub-package-rate', $permissions))
                                            <td class="whitespace-nowrap text-sm text-gray-500">
                                                {{ $r->rate }}
                                            </td>
                                        @endif --}}


                                        @canany(['show-sub-package-rate', 'specific_management_services'])
                                            <td class="whitespace-nowrap text-sm text-gray-500">
                                                {{ $r->rate }}
                                            </td>
                                        @endcanany



                                        @if (in_array('show-mother-package', $permissions))
                                            <td class="whitespace-nowrap text-sm text-gray-500">
                                                {{ $r->reseller->name ?? '' }}
                                            </td>
                                        @endif
                                        @if (in_array('show-mother-package', $permissions))
                                            <td class="whitespace-nowrap text-sm text-gray-500">
                                                {{ $r->package->package_name ?? '' }}
                                            </td>
                                        @endif
                                        @if (in_array('show-motherpackage-rate', $permissions))
                                            <td class="whitespace-nowrap text-sm text-gray-500">
                                                {{ $r->package->package_rate ?? '' }}
                                            </td>
                                        @endif
                                        @if (in_array('sub-pack-commission', $permissions))
                                            <td class="whitespace-nowrap text-sm text-gray-500">
                                                {{ $r->commission ?? '' }}
                                            </td>
                                        @endif

                                        <td class="whitespace-nowrap text-right text-sm font-medium">
                                            @if (in_array('sub-package_edit', $permissions))
                                                <a href="{{ route('sub-packages.edit', $r->id) }}"
                                                    class="btn btn-primary">Edit</a>
                                            @endif

                                            @if (in_array('sub-package_destroy', $permissions))
                                                <form action="{{ route('sub-packages.destroy', $r->id) }}" method="POST"
                                                    class="float-right pl-2"
                                                    onsubmit="return confirm('Do you really want to Delete?');">
                                                    @method('DELETE')
                                                    @csrf
                                                    <button class="btn btn-info">Delete</button>
                                                </form>
                                            @endif

                                            @if (in_array('view-sub-package-log-history', $permissions))
                                                <a href="{{ route('editLog-history', ['id' => $r->id, 'type' => 'Sub-Package']) }}"
                                                    class="btn btn-primary pull-right">History</a>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach

                                <!-- More items... -->
                            </tbody>

                        </table>
                    </div>

                    <div class="p-5">
                        {{-- {{ $sub_packages->links() }} --}}
                    </div>
                </div>
            </div>
        </div>
    </div>


    {{-- <x-Custom.modal modalTitle="Reseller Recharge">
    <x-Custom.inputGroup inputName="amount" labelName="Amount" labelIcon="" placeholder="0" inputType="number" required="required"/>
    <x-Custom.formUpdateBtn value="Recharge" class="float-right bg-blue-300 mt-2"/>
  </x-Custom.modal> --}}
@endsection


@section('ajax')
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTable').DataTable();
        });
    </script>
@endsection
