@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-body">
            <form action="" id="search" class="resellerRechargeLog">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>Select Manager</label>
                            <select name="reseller" id="reseller" class="form-control form-control-sm select2">
                                <option value="">Select One</option>
                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label> Select POP </label>
                        <select name="pop" id="pop" class="form-control form-control-sm select2">
                            <option value="all"> Select One</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group float-right mt-4">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-body" id="result">
            <div class="col-md-2">
                <a class="" href="{{ route('printToken') }}" target="_blank">
                    <button class="mb-2 btn btn-primary ">
                        <i class="fa fa-print"></i> Print
                    </button>
                </a>
            </div>
            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered table-striped table-condensed">
                    <thead class="bg-gray-50">
                        <tr class="bg-black text-center">
                            <th scope="col">ID</th>
                            <th style="padding-left: 2px;padding-right: 2px; min-width:150px; max-width:150px">Token#</th>
                            <th scope="col" class="col">Date</th>
                            <th scope="col" class="col">Category</th>
                            <th scope="col" class="col">Code</th>
                            <th scope="col" class="col">Description</th>
                            <th scope="col" class="col">Customer ID</th>
                            <th scope="col" class="col">UserName</th>
                            <th scope="col" class="col">Customer</th>
                            <th scope="col" class="col">Manager</th>
                            <th scope="col" class="col">Address</th>
                            <th scope="col" class="col">Reporter</th>
                            <th scope="col" class="col">Contact</th>
                            <th scope="col" class="col">Creator</th>
                            <th scope="col" class="col">Creator(Client)</th>
                            <th scope="col" class="col">Assigned</th>
                            <th scope="col" class="col">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($token as $r)
                            <tr>
                                <td>{{ $r->id }}</td>
                                <td style="padding-left: 2px;padding-right: 2px;max-width:150px">
                                    <span class="badge badge-success" > T.ID : </span> {{ $r->token }} <br>
                                    <span class="badge badge-info" > C.T : </span> {{ date('d-M-Y g:i: a ', strtotime($r->created_at)) }} <br>
                                    @if ($r->assign_time)
                                        <span class="badge badge-warning" > A.T : </span> {{ date('d-M-Y g:i: a ', strtotime($r->assign_time)) }} <br>
                                        @if ($r->close_time)
                                            <span class="badge badge-danger" > C.T : </span> {{ date('d-M-Y g:i: a ', strtotime($r->close_time)) }} <br>
                                        @else
                                            {{ $r->close_time ? 'Closed' . dateTimeDifferent(now(), $r->assign_time)  : 'Token Assigned ' . dateTimeDifferent(now(), $r->assign_time)." ago Not Closed" }} <br>
                                        @endif
                                    @else
                                        {{ $r->assign_time ? 'Assigned' . dateTimeDifferent(now(), $r->created_at)  : 'Token Created ' . dateTimeDifferent(now(), $r->created_at)." ago Not assigned"  }} <br>
                                    @endif
                                </td>
                                {{-- <td>{{ $r->token }}</td> --}}
                                <td style="min-width: 94px">{{ date('d-M-Y g:i: a ', strtotime($r->created_at)) }}</td>
                                <td>{{ $r->category->tokenCategory ?? '' }}</td>
                                <td style="min-width: 185px">{{ $r->Code->tokenCode ?? '' }}</td>
                                <td>{{ $r->description }}</td>
                                <td style="min-width: 104px">{{ $r->clientId }}</td>
                                <td>{{ $r->clients->userid ?? '' }}</td>
                                <td>{{ $r->clients->clientsInfo->clients_name ?? '' }}</td>
                                <td>{{ $r->clients->pops->reseller->name ?? '' }}</td>
                                <td style="width:350px;">
                                    <p style="font-size:14px;">
                                        @if (!empty($r->clients->clientsinfo->flat_no))
                                            Flat No: {{ $r->clients->clientsinfo->flat_no ?? '' }},
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->building_name))
                                            Building Name: {{ $r->clients->clientsinfo->building_name ?? '' }},<br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->road_no))
                                            Road No: {{ $r->clients->clientsinfo->road_no ?? '' }},<br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->block_sector))
                                            Block/Sector: {{ $r->clients->clientsinfo->block_sector ?? '' }},
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->area))
                                            Area : {{ $r->clients->clientsinfo->area ?? '' }}, <br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->box))
                                            Box : {{ $r->clients->clientsinfo->box ?? '' }}
                                        @endif
                                    </p>
                                </td>
                                <td>{{ $r->reportedBy }}</td>
                                <td>{{ $r->reporterContact }}</td>
                                <td> {{ $r->creator->name ?? '' }}</td>
                                <td>{{ $r->createByClient ?? '' }}</td>
                                <td>{{ $r->employees->name ?? '' }}</td>
                                <td>
                                    @can('delete-token')
                                        <form action="{{ route('token.destroy', $r->id) }}" method="POST">
                                            @method('DELETE')
                                            @csrf
                                            <button class=" btn btn-danger form-control">Delete</button>
                                        </form>
                                    @endcan
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="card-footer">
            {{-- {{ $employees->links() }} --}}
        </div>
    </div>
@endsection

@section('ajax')
    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#result').html('');
                $('#pop').html('<option value="all">Select One</option>');
            });

            $('#searchBtn').on('click', function(e) {
                e.preventDefault();
                $('body').append('<div id="processing">processing.....</div>');
                $.ajax({
                    type: 'get',
                    url: '{{ route('printTokenSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        console.log(result);
                        $('#result').html(result);
                        $('#processing').remove();
                        $('#dataTable').DataTable({
                            'destroy': true,
                        });

                    }
                });
            });


            $('#reseller').on('change', function(e) {
                e.preventDefault();
                $('body').append('<div class="hidden" id="processing">processing.....</div>');

                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerPopList') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#pop').html(result);
                        $('#processing').remove();
                    }
                });
            });

        });
    </script>
@endsection
