<!DOCTYPE HTML>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title></title>
    <style type="text/css">
        table {
            page-break-inside: auto
        }

        tr {
            page-break-inside: avoid;
            page-break-after: auto
        }

        thead {
            display: table-header-group
        }

        tfoot {
            display: table-footer-group
        }
    </style>
</head>

<body>{{--  onload="window.print()" onfocus="window.close()">--}} 

    <style>
        @media print {

            thead th {
                font-size: 15px !important;
                border: 1px solid #ddd;
                /* background-color: #4CAF50; */
            }


            #pop,
            button {
                visibility: hidden;
            }

            table {
                /* width: ; */
            }
            table,
            tr,
            thead th,
            td {
                font-size: 9px !important;
                padding: 2px !important;
                border: 1px solid #010a02;
                border-collapse: collapse;
            }

        }

        .container {
            width: 940px;
            margin: 0 auto;
            padding: 10px;
        }

        .table {

            border-collapse: collapse;
            width: 100%;
            border: 1px solid #4CAF50;
        }

        h2 {
            text-align: center;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th,
        td {
            border: 1px solid #bbb;
            padding: 10px;
            text-align: left;
        }

        tr:hover {
            background-color: #e5e5e5
        }

    </style>

    <div class="flex flex-col mt-5">
        <div class=" bg-white p-6 rounded-lg">

            <div class="p-2 mb-5">
                <button type="button" onclick="window.print()">Print
                    <i class="fa fa-print"></i>
                </button>
            </div>

            <div class="-my-2 overflow-x-auto sm:-mx-6 lg:-mx-8">
                <div class="py-2 align-middle inline-block min-w-full sm:px-2 lg:px-8">
                    <div class="shadow overflow-hidden border-b border-gray-200 sm:rounded-lg">
                        <table id="dataTable" class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Token
                                    </th>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Token Category
                                    </th>

                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Token Code
                                    </th>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Description
                                    </th>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Reported By
                                    </th>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Contact
                                    </th>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Assign To
                                    </th>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Status
                                    </th>
                                    <th scope="col"
                                        class="px-2 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                        Remarks
                                    </th>

                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">

                                @foreach ($token as $r)

                                <tr>
                                    <td class="whitespace-nowrap">
                                        {{ $r->token}}
                                    </td>
                                    <td class="whitespace-nowrap">
                                        {{$r->tokenCategory}}
                                    </td>

                                    <td class="whitespace-nowrap text-sm text-gray-500">
                                        {{$r->tokenCode}}
                                    </td>

                                    <td class="whitespace-nowrap text-sm text-gray-500">
                                        {{$r->description}}
                                    </td>
                                    <td class="whitespace-nowrap text-sm text-gray-500">
                                        {{$r->reportedBy}}
                                    </td>

                                    <td class="whitespace-nowrap">
                                        {{$r->reporterContact}}
                                    </td>
                                    <td class="whitespace-nowrap">
                                        {{$r->name}}
                                    </td>
                                    <td class="whitespace-nowrap">
                                        @if ($r->status =="Active")
                                        Not Done
                                        @else
                                        Done
                                        @endif
                                        {{-- @if ($r->status =="Active")
                                    Not Done
                                    @endif
                                    @if ($r->status =="Inactive")
                                     Done
                                    @endif --}}

                                    </td>
                                    <td class="whitespace-nowrap">
                                        {{$r->remarks}}
                                    </td>

                                </tr>

                                @endforeach

                                <!-- More items... -->
                            </tbody>
                        </table>

                        <div class="p-5">
                            {{-- {{ $employees->links() }} --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


        {{-- @section('ajax') --}}
        <script type="text/javascript">
            $(document).ready( function () {
            $('#dataTable').DataTable();
            } );

            window.onload = function() { window.print(); }
            window.onfocus=function(){ window.close(); }
        </script>

    </body>

</html>