@extends('layout.app')


@section('content')
    <div class="card">

        <div class="card-body">
                <form action="{{ route('user.update', $r->id) }}" method="POST">
                    @method('put')
                    @csrf
                    <div class="row">
                        <div class="form-group col-md-4">
                            <label for="name">
                                Name
                            </label>
                            <input value="{{ $r->name }}" class="form-control" name="name" id="name" type="text">
                            @error('name')
                                <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group col-md-4">
                            <label for="email">
                                E-Mail Address
                            </label>
                            <input value="{{ $r->email }}" class="form-control" name="email" id="email" type="email">
                            @error('email')
                                <div class="alert alert-danger">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group col-md-4">

                            <label class="block text-gray-700 text-sm font-bold mb-2" for="company">
                                Company Name
                            </label>
                            <input value="{{ $r->userdetails->company ?? '' }}" class="form-control" name="company"
                                id="company" type="text">
                            @error('company')
                                <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="form-group col-md-4">

                            <label class="block text-gray-700 text-sm font-bold mb-2" for="message">
                                Message
                            </label>

                            <input value="{{ $r->userdetails->message ?? '' }}" class="form-control" name="message"
                                id="message" type="text">
                            @error('message')
                                <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                            @enderror
                        </div>

                        @can('assign-permission')
                            <div class="form-group col-md-4">

                                <label class="block text-gray-700 text-sm font-bold mb-2" for="user_accounting_status">
                                    User Accounting
                                </label>

                                <select name="user_accounting_status" id="user_accounting_status" class="form-control select2">
                                    <option value="yes" @if ($r->user_accounting_status == 'yes') selected @endif>Yes</option>
                                    <option value="no" @if ($r->user_accounting_status == 'no') selected @endif>No</option>
                                </select>
                                @error('message')
                                    <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-4">

                                <label class="block text-gray-700 text-sm font-bold mb-2" for="user_status">
                                    Status
                                </label>

                                <select name="user_status" id="user_status" class="form-control select2">
                                    <option value="pending" @if ($r->userdetails->user_status == 'pending') selected @endif>Pending</option>
                                    <option value="active" @if ($r->userdetails->user_status == 'active') selected @endif>Active</option>
                                    <option value="deactive" @if ($r->userdetails->user_status == 'deactive') selected @endif>Deactive</option>
                                </select>
                                @error('message')
                                    <div class="text-red-500 mt-2 text-sm">{{ $message }}</div>
                                @enderror
                            </div>
                        @endcan

                        <div class="form-group col-md-4">

                            <label for="company">
                                Mobile Number
                            </label>
                            <input value="{{$r->mobile_number}}" class="form-control" name="mobile_number" id="mobile_number"
                                type="text" autocomplete="off" placeholder="01733344466">
                            @error('mobile_number')
                                <div class="alert alert-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        @if (checkSettings('reseller-client-dynamic-recharge') == 'enable')
                            <div class="form-group col-md-4">
                                <label for="company">Client Recharge Days(Minimum)</label>
                                <input value="{{$r->minimum_recharge_day}}" class="form-control" name="minimum_recharge_day" id="minimum_recharge_day"
                                    type="number" autocomplete="off" placeholder="Recharge Day">
                                @error('minimum_recharge_day')
                                    <div class="alert alert-danger">{{ $message }}</div>
                                @enderror
                            </div>
                        @endif
                    </div>


                    <div class="form-group">

                        <a href="{{ route('user.index') }}" class="btn btn-default"><i class="fa fa-arrow-left"></i>
                            Back</a>

                        <button type="submit" class="btn btn-primary float-right">
                            Update
                        </button>

                    </div>


                </form>
        </div>
    </div>
@endsection
