@extends('layout.app')
@section('content')


<div class="card">
    <div class="card-body">
        <form action="{{ route('assignResellerUpdate',$user->id) }}" method="POST">
            @method('PUT')
            @csrf

            
            <h2 class="page-header">User Name :
                {{ $user->name }}</h2>

                @error('reseller_id') <p class="w-1/2 m-auto text-center text-white bg-yellow-300 m-2 p-2">{{$message}} </p>@enderror

                <table class="table">
                  <tr>
                    <th>ID</th>
                    <th>Reseller Name</th>
                    <th>Reseller Address</th>
                    <th></th>
                  </tr>
                  @foreach($reseller as $r )
                  <tr>
                    
                    <td>{{ $r->id }}</td>
                    <td>{{ $r->name }}</td>
                    <td>{{ $r->address }}</td>
                    <td>

                      <div class="form-group">

                        <div class="custom-control custom-switch">
                          {{-- <input type="checkbox" class="custom-control-input" id="customSwitch1"> --}}
                          
                          <input class="custom-control-input" id="reseller{{$r->id}}" name="reseller[]" type="checkbox" value="{{ $r->id }}"                      
                            @foreach($user->resellers as $reseller)                      
                              @if( $reseller->id == $r->id )
                              checked
                              @endif
                            @endforeach
                            >
                          <label class="custom-control-label" for="reseller{{$r->id}}"></label>
                        </div>
                        
                      </div>

                      
                      
                    </td>
                  </tr>
                  @endforeach

                </table>
                
                <div class="form-group">
                  <a href="{{route('user.index')}}" class="btn btn-default"><i class="fa fa-arrow-left"></i> Back</a>
                  <input type="submit" class="btn btn-primary float-right"
                  value="Assign Reseller">
                </div>
        </form>
    </div>
</div>



@endsection
