<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ClientController;
use App\Http\Controllers\UddoktapayController;
use App\Http\Controllers\Api\BillPaymentController;
use App\Http\Controllers\Api\PrepaidBillPaymentController;
use App\Http\Controllers\BkashWebhookController;
use App\Http\Controllers\MikrotikController;
use App\Http\Controllers\NagadIpnController;
use App\Services\ApiBandwidthUsageService;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get("hello-test", function () {
    $onlineClient = new ApiBandwidthUsageService;
    dd($onlineClient->UpdateOnlineClientBandwidthUsage());
    return "hello world";
});

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/customer/{userid}', [ClientController::class, 'showApi']);
Route::post('/getCustomerInfo', [ClientController::class, 'getCustomerInfo']);

Route::get('/total-customer', [ClientController::class, 'totalClient']);

// customer bill pay version 1

Route::post('bill-pay/v1/check-bill', [BillPaymentController::class, 'checkBill']);
Route::get('bill-pay/v1/check-bill', function () {
    abort(404, 'Not Found');
});

Route::post('bill-pay/v1/payment', [BillPaymentController::class, 'payment']);
Route::post('bill-pay/v1/search', [BillPaymentController::class, 'search']);
Route::delete('bill-pay/v1/delete', [BillPaymentController::class, 'delete']);

// pay-bill(prepaid)
Route::post('pay-bill/v2/bill-check', [PrepaidBillPaymentController::class, 'checkPrepaidBill']);
Route::get('pay-bill/v2/bill-check', function () {
    abort(404, 'Sorry, Not Found!');
});

Route::post('pay-bill/v2/pre-payment', [PrepaidBillPaymentController::class, 'prePayment']);
Route::post('pay-bill/v2/bill-search', [PrepaidBillPaymentController::class, 'billSearch']);

// uddokta pay route

Route::post('webhook-uddokta-pay', [UddoktapayController::class, 'webhook'])->name('uddoktapay.webhook');



Route::get('/mikrotik-information/{id}/{email}',[MikrotikController::class,'getMikrotik']);
Route::post('pgw-nagad/v1/ipn', [NagadIpnController::class, 'save']);

Route::post('bkashWebhook', [BkashWebhookController::class, 'handleWebhook'])->name('bkash.webhook');
