<?php

use App\Models\CustomerAccount;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BkashController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\DemoPageController;
use App\Http\Controllers\UddoktapayController;
use App\Http\Controllers\Customer\TokenController;
use App\Http\Controllers\SslCommerzPaymentController;
use App\Http\Controllers\Customer\BkashCheckoutController;
use App\Http\Controllers\Customer\CustomerFrontController;
use App\Http\Controllers\Customer\OpenPaymentController;
use App\Http\Controllers\NagadCheckOutCustomerPaymentController;
use App\Http\Controllers\UpayPaymentController;

Route::get('/', function () {

    if (request()->getHost() == '103.152.103.212') {
        return redirect('admin/login');
    } elseif (request()->getHost() == '103.170.204.18') {
        return redirect('admin/login');
    } elseif (request()->getHost() == '103.170.204.178') {
        return redirect('admin/login');
    } elseif (request()->getHost() == 'erp2.circlenetworkbd.com') {
        return redirect('admin/login');
    } else {
        return redirect('customer_login');
    }
});


Route::get('demo', [DemoPageController::class, 'demo_page'])->name('demo_page');
Route::get('customer_login', [CustomerFrontController::class, 'customer_login'])->name('customer_login');
Route::post('customer_login', [CustomerFrontController::class, 'customer_login_check'])->name('customer_login_check')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::get('forget_password', [CustomerFrontController::class, 'forget_password'])->name('forget_password');
Route::post('forget_password', [CustomerFrontController::class, 'forget_password_process'])->name('forget_password_process');

Route::get('customerDashboard', [CustomerFrontController::class, 'customerDashboard'])->name('customerDashboard');

Route::get('account', [CustomerFrontController::class, 'customer_account'])->name('account');

Route::get('customer-logout', [CustomerFrontController::class, 'logout'])->name('customer-logout');

Route::get('customer-contact', [CustomerFrontController::class, 'contact'])->name('customer-contact');
Route::get('customer-packages', [CustomerFrontController::class, 'customerPackages'])->name('customer-packages');
Route::resource('customer-token', TokenController::class);
Route::get('getCustomerTokenList', [TokenController::class, 'getCustomerTokenList'])->name('getCustomerTokenList');
Route::get('customerTokenList', [TokenController::class, 'customerTokenList'])->name('customerTokenList');
Route::get('pendingTokenList', [TokenController::class, 'pendingTokenList'])->name('pendingTokenList');

Route::get('customer-payment-history', [CustomerFrontController::class, 'payment_history'])->name('customer-payment-history');
Route::get('customer-payment', [CustomerFrontController::class, 'payment'])->name('customer-payment');

Route::post('payment-process', [CustomerFrontController::class, 'payment_process'])->name('payment-process');


Route::get('onlinepaymenttest', [PaymentController::class, 'sslpayment'])->name('onlinepaymenttest');

// Payment Routes for bKash tokenized
Route::post('bkash/get-token-tokenized', [BkashController::class, 'generateToken'])->name('bkash-get-token')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::post('bkash/create-payment-tokenized', [BkashController::class, 'createPayment'])->name('bkash-create-payment');
Route::post('bkash/execute-payment-tokenized', [BkashController::class, 'executePayment'])->name('bkash-execute-payment')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::get('bkash/query-payment-tokenized', [BkashController::class, 'queryPayment'])->name('bkash-query-payment');
Route::post('bkash/success', [BkashController::class, 'bkashSuccess'])->name('bkash-success')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);



// Payment Routes for bKash checkout
Route::post('bkash/get-token', [BkashCheckoutController::class, 'getToken'])->name('checkout-bkash-get-token')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::post('bkash/create-payment', [BkashCheckoutController::class, 'createPayment'])->name('checkout-bkash-create-payment')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::post('bkash/execute-payment', [BkashCheckoutController::class, 'executePayment'])->name('checkout-bkash-execute-payment')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::get('bkash/query-payment', [BkashCheckoutController::class, 'queryPayment'])->name('checkout-bkash-query-payment')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::post('bkash/success', [BkashCheckoutController::class, 'bkashSuccess'])->name('checkout-bkash-success')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);



Route::get('bkashCheckout', [BkashController::class, 'checkout'])->name('bkashCheckout');


Route::get('bkashCanceled', [CustomerFrontController::class, 'bkashPaymentCanceled'])->name('bkashCanceled');
Route::get('bkashFailure', [CustomerFrontController::class, 'bkashPaymentbkashFailure'])->name('bkashFailure');
Route::get('insufficientBalance', [CustomerFrontController::class, 'insufficientBalance'])->name('insufficientBalance');
Route::get('bkashError', [CustomerFrontController::class, 'bkashError'])->name('bkashError');

// payment routes for ssl commerz


Route::post('/pay', [SslCommerzPaymentController::class, 'index']);
Route::post('/pay-via-ajax', [SslCommerzPaymentController::class, 'payViaAjax']);

Route::post('/success', [SslCommerzPaymentController::class, 'success']);
Route::post('/fail', [SslCommerzPaymentController::class, 'fail']);

Route::post('fail', [CustomerFrontController::class, 'payment'])->name('fail');

Route::post('/cancel', [SslCommerzPaymentController::class, 'cancel']);
Route::post('/ipn', [SslCommerzPaymentController::class, 'ipn']);

Route::get('sslVarification', [SslCommerzPaymentController::class, 'sslVarification'])->name('sslVarification');


// uddokta pay configuration


Route::get('pay', [UddoktapayController::class, 'show'])->name('uddoktapay.payment-form');
Route::post('pay', [UddoktapayController::class, 'pay'])->name('uddoktapay.pay')->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]);
Route::get('success', [UddoktapayController::class, 'success'])->name('uddoktapay.success');
Route::get('cancel', [UddoktapayController::class, 'cancel'])->name('uddoktapay.cancel');
Route::get('upay-payment-token', [UpayPaymentController::class, 'upayPaymenToken'])->name('upay-payment-token');
Route::get('upayCheckout', [UpayPaymentController::class, 'upayCheckout'])->name('upayCheckout');

Route::get('nagad-payment-token', [NagadCheckOutCustomerPaymentController::class, 'nagadPaymenToken'])->name('nagad-payment-token');
Route::get('nagad-payment-callback', [NagadCheckOutCustomerPaymentController::class, 'nagadPaymenCallback'])->name('nagad-payment-callback');

Route::get('client-payment/{token}', [OpenPaymentController::class, 'openPayment'])->name('client-open-payment');
Route::get('get-client-speed', [ClientController::class, 'getSpeed'])->name('getClientSpeed');
