<?php

namespace App\Http\Controllers;

use App\Jobs\MakeClientCloseJob;
use App\Models\Client;
use Illuminate\Http\Request;

class AutoCloseController extends Controller
{
    public function autoClose()
    {

        $days_90_ago = now()->subMonth(3)->subDay(1)->format('Y-m-d 00:00:00');


        $all_expired_clients_over_90_days = Client::with('pop', 'pop.nas', 'clientsinfo')->whereDate('expire_date', '<=', $days_90_ago)
            ->whereNull('deleted_at')
            ->get();



        foreach ($all_expired_clients_over_90_days as $client) {
            $details = "Client close";

            if ($client->deleted_at == null) {
                MakeClientCloseJob::dispatch($client, $details, 1);
            }
        }
    }
}
