<?php

namespace App\Http\Controllers;

use App\Models\AccountingServer;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Artisan;

class AccountingServerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(auth()->user()->id != 1){
            Toastr::error("Do not have permission");
            return redirect()->back();
        }

        $data = [
            'servers' => AccountingServer::get(),
        ];

        return view('accountingServer.index',$data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name'=>'required|unique:accounting_servers'
        ]);


        $accountingServer = new AccountingServer();
        $accountingServer->name = $request->name;
        $accountingServer->is_enable = $request->is_enable;
        $accountingServer->save();

        Cache::forget('activeServerLists');
        Artisan::call('cache:clear');
        Artisan::call('optimize:clear');
        exec('/usr/bin/sudo supervisorctl restart all');

        Toastr::success("Server Add successfull");
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AccountingServer  $accountingServer
     * @return \Illuminate\Http\Response
     */
    public function show(AccountingServer $accountingServer)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AccountingServer  $accountingServer
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $server = AccountingServer::find($id);

        $data = [
            'server' => $server,
        ];
        return view('accountingServer.edit',$data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AccountingServer  $accountingServer
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name'=>'required|unique:accounting_servers,name,' . $id,
        ]);

        $accountingServer = AccountingServer::find($id);
        $accountingServer->name = $request->name;
        $accountingServer->is_enable = $request->is_enable;
        $accountingServer->save();


        Cache::forget('activeServerLists');
        Artisan::call('cache:clear');
        Artisan::call('optimize:clear');
        exec('/usr/bin/sudo supervisorctl restart all');

        Toastr::success("Server Update successfull");
        return redirect()->back();

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AccountingServer  $accountingServer
     * @return \Illuminate\Http\Response
     */
    public function destroy(AccountingServer $accountingServer)
    {
        //
    }
}
