<?php

namespace App\Jobs;

use App\Classes\MikrotikService\Mikrotik;
use App\Models\Client;
use Exception;
use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Contracts\Queue\ShouldBeUnique;

use Illuminate\Support\Facades\DB;


class ApiClientExpireJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */

    private $data;

    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $firstUser = Client::with('pop', 'pop.nas')->where('userid', $this->data[0]->userid)->first();
        $nasDetail = $firstUser->pop->nas;

        $mkIp = $nasDetail->nasname;
        $mkUsername = $nasDetail->mikrotick_user;
        $mkPassword = $nasDetail->mikrotick_user_password;
        $mkPort = $nasDetail->mikrotick_port;


        $mk = new Mikrotik($mkIp, $mkUsername, $mkPassword, $mkPort ? (int)$mkPort : 8728);
        foreach ($this->data as $d) {
            try {
                $mk->disconnectAndDisableSecret($d->userid);
            } catch (Exception $err) {
            }
        }
    }
}
