<?php

namespace App\Services;

use Carbon\Carbon;
use App\Models\Client;
use App\Models\Packages;
use App\Models\BillGenerate;
use App\Models\BillGeneratesArchive;
use App\Services\ExpireCheck;
use App\Models\CustomerAccount;
use App\Models\Pop;
use App\Models\Reseller;
use App\Models\ResellerCommissionReference;
use App\Models\SubResellerCommissionReference;
use App\Services\PriceCalculate;
use Illuminate\Support\Facades\DB;

class CommissionService
{
    public function reseller_commission($amount, $actions, $reseller_id, $commission, $package_price, $client_id, $bill_or_payment = null, $bill_or_payment_id = null)
    {
        // dd($commission);
        if ($commission > 0 || globalPermission('commission_from_manager_pop')) {
            if (globalPermission('commission_from_manager_pop')) {
                $thisResellerCommission = Reseller::find($reseller_id);
                $commission = $thisResellerCommission->commission_percentage;
                $package_price = 100;
            }
            if ($bill_or_payment == "bill") {
                ResellerCommissionReference::create([
                    'received_amount' => $this->calculateCommission($commission, $package_price, $amount),
                    'actions' => $actions,
                    'user_id' => auth()->user()->id ?? 1,
                    'reseller_id' => $reseller_id,
                    'client_id' => $client_id,
                    'bill_generate_id' => $bill_or_payment_id,
                ]);
            } else if ($bill_or_payment == "payment") {
                ResellerCommissionReference::create([
                    'received_amount' => $this->calculateCommission($commission, $package_price, $amount),
                    'actions' => $actions,
                    'user_id' => auth()->user()->id ?? 1,
                    'reseller_id' => $reseller_id,
                    'client_id' => $client_id,
                    'bill_payment_id' => $bill_or_payment_id,

                ]);
            } else {

                ResellerCommissionReference::create([
                    'received_amount' => $this->calculateCommission($commission, $package_price, $amount),
                    'actions' => $actions,
                    'user_id' => auth()->user()->id ?? 1,
                    'reseller_id' => $reseller_id,
                    'client_id' => $client_id

                ]);
            }
        }
    }

    public function subreseller_commission($amount, $actions, $pop_id, $commission, $package_price, $client_id, $bill_or_payment = null, $bill_or_payment_id = null)
    {
        if ($commission > 0 || globalPermission('commission_from_manager_pop')) {
            if (globalPermission('commission_from_manager_pop')) {
                $thisSubResellerCommission = Pop::find($pop_id);
                $commission = $thisSubResellerCommission->commission_percentage;
                $package_price = 100;
            }

            if ($bill_or_payment == "bill") {
                SubResellerCommissionReference::create([
                    'received_amount' => $this->calculateCommission($commission, $package_price, $amount),
                    'actions' => $actions,
                    'user_id' => auth()->user()->id ?? 1,
                    'pop_id' => $pop_id,
                    'client_id' => $client_id,
                    'bill_generate_id' => $bill_or_payment_id
                ]);
            } else if ($bill_or_payment == "payment") {
                SubResellerCommissionReference::create([
                    'received_amount' => $this->calculateCommission($commission, $package_price, $amount),
                    'actions' => $actions,
                    'user_id' => auth()->user()->id ?? 1,
                    'pop_id' => $pop_id,
                    'client_id' => $client_id,
                    'payment_id' => $bill_or_payment_id
                ]);
            } else {

                SubResellerCommissionReference::create([
                    'received_amount' => $this->calculateCommission($commission, $package_price, $amount),
                    'actions' => $actions,
                    'user_id' => auth()->user()->id ?? 1,
                    'pop_id' => $pop_id,
                    'client_id' => $client_id
                ]);
            }
        }
    }

    public function calculateCommission($commission, $package_price, $amount)
    {
        return (($commission * $amount) / $package_price);
    }
}
