@php
    use Illuminate\Support\Facades\Redis;
@endphp
@props(['isStatic', 'userid', 'ip_address', 'online'])

@if (!$isStatic)
    @php
        $userid = $userid ?? '';
        $useRedis = globalPermission('clientManageThroughNodeJs');

        if ($useRedis) {
            $userActiveInfo = json_decode(Redis::get('active:' . $userid), true);
            $userSecretInfo = json_decode(Redis::get('secret:' . $userid), true);
            $isOnline = $userActiveInfo !== null;
            $currentAddress = $userActiveInfo['address'] ?? '';
            $lastLoggedOut = $userSecretInfo['last-logged-out'] ?? null;
        } else {
            $isOnline = array_key_exists($userid, $online['onlineUsers']);
            $currentAddress = $online['onlineUsers'][$userid]['address'] ?? '';
            $lastLoggedOut = $online['allUsers'][$userid]['last-logged-out'] ?? null;
        }
    @endphp

    @if ($isOnline)
        @can('router-remote-access')
            <a href="http://{{ $currentAddress }}:{{ siteinfo()->remote_router_port ?? '' }}"
                class="" target="_blank">
                <i class="fa fa-sign-out bg-info text-light p-1 rounded-circle" aria-hidden="true"
                    style="font-size: 0.75rem;"></i>
            </a>
        @endcan
        <span class="btn-success btn-xs">
            @if (globalPermission('online-offline-using-api'))
                Online
            @else
                {{ $currentAddress }}
            @endif
        </span>
    @else
        @if ($lastLoggedOut)
            @if (preg_match('/\b\d{4}\b/', $lastLoggedOut, $matches) == 1)
                @if ($matches[0] != '1970')
                    <span class="btn btn-danger btn-xs">
                        @if (globalPermission('online-offline-using-api'))
                            Offline
                        @else
                            {{ $useRedis ? $lastLoggedOut : parseDate($lastLoggedOut) }}
                        @endif
                    </span>
                @else
                    <span class="btn-warning btn-xs p-1 text-light">
                        Never Connected
                    </span>
                @endif
            @endif
        @endif
    @endif
@else
    @if(isset($ip_address)) {
        @if (array_key_exists($ip_address, $online['ipArpListsGlobal']))
            <span class="mt-1 btn @if ($online['ipArpListsGlobal'][$ip_address]['disabled'] == 'false') btn-success @else btn-danger @endif btn-xs">
                {{ $online['ipArpListsGlobal'][$ip_address]['disabled'] == 'false' ? 'Online' : 'ARP-Disabled' }}
            </span>
        @endif
    @else
        <span class="btn btn-danger btn-xs">Offline</span>
    @endif
@endif
